package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Zilei5;
import com.xforceplus.new20.service.IZilei5Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * zilei5前端控制器
 *
 * @author ultraman
 * @date 2023-08-14
 */
@RestController
public class Zilei5Controller {

  @Autowired
  private IZilei5Service zilei5ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zilei5 zilei5
   * @return
   */
  @GetMapping("/zilei5s" )
  public XfR getZilei5s(XfPage page, Zilei5 zilei5) {
    return XfR.ok(zilei5ServiceImpl.page(page, Wrappers.query(zilei5)));
  }

  /**
   * 通过id查询zilei5
   * @param  id
   * @return XfR
   */
  @GetMapping("/zilei5s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zilei5ServiceImpl.getById(id));
  }

  /**
   * 新增zilei5
   * @param zilei5 zilei5
   * @return XfR
   */
  @PostMapping("/zilei5s")
  public XfR save(@RequestBody Zilei5 zilei5) {
     return XfR.ok(zilei5ServiceImpl.save(zilei5));
  }

  /**
   * 修改-传入修改后的全部数据zilei5
   * @param zilei5 zilei5
   * @return XfR
   */
  @PutMapping("/zilei5s/{id}")
  public XfR putUpdate(@RequestBody Zilei5 zilei5,@PathVariable Long id) {
      zilei5.setId(id);
      return XfR.ok(zilei5ServiceImpl.updateById(zilei5));
  }

  /**
   * 修改-传入修改的数据zilei5
   * @param zilei5 zilei5
   * @return XfR
   */
  @PatchMapping("/zilei5s/{id}")
  public XfR patchUpdate(@RequestBody Zilei5 zilei5,@PathVariable Long id) {
      Zilei5 upzilei5 = zilei5ServiceImpl.getById(id);
      if(upzilei5 != null){
        upzilei5 = ObjectCopyUtils.copyProperties(zilei5,upzilei5,true);
      }
      return XfR.ok(zilei5ServiceImpl.updateById(upzilei5));
  }

  /**
   * 通过id删除zilei5
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zilei5s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zilei5ServiceImpl.removeById(id));
  }

  @PostMapping("/zilei5s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zilei5");
     params.put("request", condition);

     return XfR.ok(zilei5ServiceImpl.querys(params));
  }

}
