package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Fulei1;
import com.xforceplus.new20.service.IFulei1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * fulei1前端控制器
 *
 * @author ultraman
 * @date 2023-05-22
 */
@RestController
public class Fulei1Controller {

  @Autowired
  private IFulei1Service fulei1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fulei1 fulei1
   * @return
   */
  @GetMapping("/fulei1s" )
  public XfR getFulei1s(XfPage page, Fulei1 fulei1) {
    return XfR.ok(fulei1ServiceImpl.page(page, Wrappers.query(fulei1)));
  }

  /**
   * 通过id查询fulei1
   * @param  id
   * @return XfR
   */
  @GetMapping("/fulei1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fulei1ServiceImpl.getById(id));
  }

  /**
   * 新增fulei1
   * @param fulei1 fulei1
   * @return XfR
   */
  @PostMapping("/fulei1s")
  public XfR save(@RequestBody Fulei1 fulei1) {
     return XfR.ok(fulei1ServiceImpl.save(fulei1));
  }

  /**
   * 修改-传入修改后的全部数据fulei1
   * @param fulei1 fulei1
   * @return XfR
   */
  @PutMapping("/fulei1s/{id}")
  public XfR putUpdate(@RequestBody Fulei1 fulei1,@PathVariable Long id) {
      fulei1.setId(id);
      return XfR.ok(fulei1ServiceImpl.updateById(fulei1));
  }

  /**
   * 修改-传入修改的数据fulei1
   * @param fulei1 fulei1
   * @return XfR
   */
  @PatchMapping("/fulei1s/{id}")
  public XfR patchUpdate(@RequestBody Fulei1 fulei1,@PathVariable Long id) {
      Fulei1 upfulei1 = fulei1ServiceImpl.getById(id);
      if(upfulei1 != null){
        upfulei1 = ObjectCopyUtils.copyProperties(fulei1,upfulei1,true);
      }
      return XfR.ok(fulei1ServiceImpl.updateById(upfulei1));
  }

  /**
   * 通过id删除fulei1
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fulei1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fulei1ServiceImpl.removeById(id));
  }

  @PostMapping("/fulei1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fulei1");
     params.put("request", condition);

     return XfR.ok(fulei1ServiceImpl.querys(params));
  }

}
