package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Fulei2;
import com.xforceplus.new20.service.IFulei2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * fulei2前端控制器
 *
 * @author ultraman
 * @date 2023-05-22
 */
@RestController
public class Fulei2Controller {

  @Autowired
  private IFulei2Service fulei2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fulei2 fulei2
   * @return
   */
  @GetMapping("/fulei2s" )
  public XfR getFulei2s(XfPage page, Fulei2 fulei2) {
    return XfR.ok(fulei2ServiceImpl.page(page, Wrappers.query(fulei2)));
  }

  /**
   * 通过id查询fulei2
   * @param  id
   * @return XfR
   */
  @GetMapping("/fulei2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fulei2ServiceImpl.getById(id));
  }

  /**
   * 新增fulei2
   * @param fulei2 fulei2
   * @return XfR
   */
  @PostMapping("/fulei2s")
  public XfR save(@RequestBody Fulei2 fulei2) {
     return XfR.ok(fulei2ServiceImpl.save(fulei2));
  }

  /**
   * 修改-传入修改后的全部数据fulei2
   * @param fulei2 fulei2
   * @return XfR
   */
  @PutMapping("/fulei2s/{id}")
  public XfR putUpdate(@RequestBody Fulei2 fulei2,@PathVariable Long id) {
      fulei2.setId(id);
      return XfR.ok(fulei2ServiceImpl.updateById(fulei2));
  }

  /**
   * 修改-传入修改的数据fulei2
   * @param fulei2 fulei2
   * @return XfR
   */
  @PatchMapping("/fulei2s/{id}")
  public XfR patchUpdate(@RequestBody Fulei2 fulei2,@PathVariable Long id) {
      Fulei2 upfulei2 = fulei2ServiceImpl.getById(id);
      if(upfulei2 != null){
        upfulei2 = ObjectCopyUtils.copyProperties(fulei2,upfulei2,true);
      }
      return XfR.ok(fulei2ServiceImpl.updateById(upfulei2));
  }

  /**
   * 通过id删除fulei2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fulei2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fulei2ServiceImpl.removeById(id));
  }

  @PostMapping("/fulei2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fulei2");
     params.put("request", condition);

     return XfR.ok(fulei2ServiceImpl.querys(params));
  }

}
