package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Fulei3;
import com.xforceplus.new20.service.IFulei3Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * fulei3前端控制器
 *
 * @author ultraman
 * @date 2023-05-22
 */
@RestController
public class Fulei3Controller {

  @Autowired
  private IFulei3Service fulei3ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fulei3 fulei3
   * @return
   */
  @GetMapping("/fulei3s" )
  public XfR getFulei3s(XfPage page, Fulei3 fulei3) {
    return XfR.ok(fulei3ServiceImpl.page(page, Wrappers.query(fulei3)));
  }

  /**
   * 通过id查询fulei3
   * @param  id
   * @return XfR
   */
  @GetMapping("/fulei3s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fulei3ServiceImpl.getById(id));
  }

  /**
   * 新增fulei3
   * @param fulei3 fulei3
   * @return XfR
   */
  @PostMapping("/fulei3s")
  public XfR save(@RequestBody Fulei3 fulei3) {
     return XfR.ok(fulei3ServiceImpl.save(fulei3));
  }

  /**
   * 修改-传入修改后的全部数据fulei3
   * @param fulei3 fulei3
   * @return XfR
   */
  @PutMapping("/fulei3s/{id}")
  public XfR putUpdate(@RequestBody Fulei3 fulei3,@PathVariable Long id) {
      fulei3.setId(id);
      return XfR.ok(fulei3ServiceImpl.updateById(fulei3));
  }

  /**
   * 修改-传入修改的数据fulei3
   * @param fulei3 fulei3
   * @return XfR
   */
  @PatchMapping("/fulei3s/{id}")
  public XfR patchUpdate(@RequestBody Fulei3 fulei3,@PathVariable Long id) {
      Fulei3 upfulei3 = fulei3ServiceImpl.getById(id);
      if(upfulei3 != null){
        upfulei3 = ObjectCopyUtils.copyProperties(fulei3,upfulei3,true);
      }
      return XfR.ok(fulei3ServiceImpl.updateById(upfulei3));
  }

  /**
   * 通过id删除fulei3
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fulei3s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fulei3ServiceImpl.removeById(id));
  }

  @PostMapping("/fulei3s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fulei3");
     params.put("request", condition);

     return XfR.ok(fulei3ServiceImpl.querys(params));
  }

}
