package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.One0518001;
import com.xforceplus.new20.service.IOne0518001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * one0518001前端控制器
 *
 * @author ultraman
 * @date 2023-05-22
 */
@RestController
public class One0518001Controller {

  @Autowired
  private IOne0518001Service one0518001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param one0518001 one0518001
   * @return
   */
  @GetMapping("/one0518001s" )
  public XfR getOne0518001s(XfPage page, One0518001 one0518001) {
    return XfR.ok(one0518001ServiceImpl.page(page, Wrappers.query(one0518001)));
  }

  /**
   * 通过id查询one0518001
   * @param  id
   * @return XfR
   */
  @GetMapping("/one0518001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(one0518001ServiceImpl.getById(id));
  }

  /**
   * 新增one0518001
   * @param one0518001 one0518001
   * @return XfR
   */
  @PostMapping("/one0518001s")
  public XfR save(@RequestBody One0518001 one0518001) {
     return XfR.ok(one0518001ServiceImpl.save(one0518001));
  }

  /**
   * 修改-传入修改后的全部数据one0518001
   * @param one0518001 one0518001
   * @return XfR
   */
  @PutMapping("/one0518001s/{id}")
  public XfR putUpdate(@RequestBody One0518001 one0518001,@PathVariable Long id) {
      one0518001.setId(id);
      return XfR.ok(one0518001ServiceImpl.updateById(one0518001));
  }

  /**
   * 修改-传入修改的数据one0518001
   * @param one0518001 one0518001
   * @return XfR
   */
  @PatchMapping("/one0518001s/{id}")
  public XfR patchUpdate(@RequestBody One0518001 one0518001,@PathVariable Long id) {
      One0518001 upone0518001 = one0518001ServiceImpl.getById(id);
      if(upone0518001 != null){
        upone0518001 = ObjectCopyUtils.copyProperties(one0518001,upone0518001,true);
      }
      return XfR.ok(one0518001ServiceImpl.updateById(upone0518001));
  }

  /**
   * 通过id删除one0518001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/one0518001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(one0518001ServiceImpl.removeById(id));
  }

  @PostMapping("/one0518001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "one0518001");
     params.put("request", condition);

     return XfR.ok(one0518001ServiceImpl.querys(params));
  }

}
