package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.One0519001;
import com.xforceplus.new20.service.IOne0519001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * one0519001前端控制器
 *
 * @author ultraman
 * @date 2023-05-22
 */
@RestController
public class One0519001Controller {

  @Autowired
  private IOne0519001Service one0519001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param one0519001 one0519001
   * @return
   */
  @GetMapping("/one0519001s" )
  public XfR getOne0519001s(XfPage page, One0519001 one0519001) {
    return XfR.ok(one0519001ServiceImpl.page(page, Wrappers.query(one0519001)));
  }

  /**
   * 通过id查询one0519001
   * @param  id
   * @return XfR
   */
  @GetMapping("/one0519001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(one0519001ServiceImpl.getById(id));
  }

  /**
   * 新增one0519001
   * @param one0519001 one0519001
   * @return XfR
   */
  @PostMapping("/one0519001s")
  public XfR save(@RequestBody One0519001 one0519001) {
     return XfR.ok(one0519001ServiceImpl.save(one0519001));
  }

  /**
   * 修改-传入修改后的全部数据one0519001
   * @param one0519001 one0519001
   * @return XfR
   */
  @PutMapping("/one0519001s/{id}")
  public XfR putUpdate(@RequestBody One0519001 one0519001,@PathVariable Long id) {
      one0519001.setId(id);
      return XfR.ok(one0519001ServiceImpl.updateById(one0519001));
  }

  /**
   * 修改-传入修改的数据one0519001
   * @param one0519001 one0519001
   * @return XfR
   */
  @PatchMapping("/one0519001s/{id}")
  public XfR patchUpdate(@RequestBody One0519001 one0519001,@PathVariable Long id) {
      One0519001 upone0519001 = one0519001ServiceImpl.getById(id);
      if(upone0519001 != null){
        upone0519001 = ObjectCopyUtils.copyProperties(one0519001,upone0519001,true);
      }
      return XfR.ok(one0519001ServiceImpl.updateById(upone0519001));
  }

  /**
   * 通过id删除one0519001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/one0519001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(one0519001ServiceImpl.removeById(id));
  }

  @PostMapping("/one0519001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "one0519001");
     params.put("request", condition);

     return XfR.ok(one0519001ServiceImpl.querys(params));
  }

}
