package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Oneobject10;
import com.xforceplus.new20.service.IOneobject10Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * oneobject10前端控制器
 *
 * @author ultraman
 * @date 2023-05-22
 */
@RestController
public class Oneobject10Controller {

  @Autowired
  private IOneobject10Service oneobject10ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oneobject10 oneobject10
   * @return
   */
  @GetMapping("/oneobject10s" )
  public XfR getOneobject10s(XfPage page, Oneobject10 oneobject10) {
    return XfR.ok(oneobject10ServiceImpl.page(page, Wrappers.query(oneobject10)));
  }

  /**
   * 通过id查询oneobject10
   * @param  id
   * @return XfR
   */
  @GetMapping("/oneobject10s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oneobject10ServiceImpl.getById(id));
  }

  /**
   * 新增oneobject10
   * @param oneobject10 oneobject10
   * @return XfR
   */
  @PostMapping("/oneobject10s")
  public XfR save(@RequestBody Oneobject10 oneobject10) {
     return XfR.ok(oneobject10ServiceImpl.save(oneobject10));
  }

  /**
   * 修改-传入修改后的全部数据oneobject10
   * @param oneobject10 oneobject10
   * @return XfR
   */
  @PutMapping("/oneobject10s/{id}")
  public XfR putUpdate(@RequestBody Oneobject10 oneobject10,@PathVariable Long id) {
      oneobject10.setId(id);
      return XfR.ok(oneobject10ServiceImpl.updateById(oneobject10));
  }

  /**
   * 修改-传入修改的数据oneobject10
   * @param oneobject10 oneobject10
   * @return XfR
   */
  @PatchMapping("/oneobject10s/{id}")
  public XfR patchUpdate(@RequestBody Oneobject10 oneobject10,@PathVariable Long id) {
      Oneobject10 uponeobject10 = oneobject10ServiceImpl.getById(id);
      if(uponeobject10 != null){
        uponeobject10 = ObjectCopyUtils.copyProperties(oneobject10,uponeobject10,true);
      }
      return XfR.ok(oneobject10ServiceImpl.updateById(uponeobject10));
  }

  /**
   * 通过id删除oneobject10
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oneobject10s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oneobject10ServiceImpl.removeById(id));
  }

  @PostMapping("/oneobject10s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oneobject10");
     params.put("request", condition);

     return XfR.ok(oneobject10ServiceImpl.querys(params));
  }

}
