package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Oneobject5;
import com.xforceplus.new20.service.IOneobject5Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * oneobject5前端控制器
 *
 * @author ultraman
 * @date 2023-05-22
 */
@RestController
public class Oneobject5Controller {

  @Autowired
  private IOneobject5Service oneobject5ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oneobject5 oneobject5
   * @return
   */
  @GetMapping("/oneobject5s" )
  public XfR getOneobject5s(XfPage page, Oneobject5 oneobject5) {
    return XfR.ok(oneobject5ServiceImpl.page(page, Wrappers.query(oneobject5)));
  }

  /**
   * 通过id查询oneobject5
   * @param  id
   * @return XfR
   */
  @GetMapping("/oneobject5s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oneobject5ServiceImpl.getById(id));
  }

  /**
   * 新增oneobject5
   * @param oneobject5 oneobject5
   * @return XfR
   */
  @PostMapping("/oneobject5s")
  public XfR save(@RequestBody Oneobject5 oneobject5) {
     return XfR.ok(oneobject5ServiceImpl.save(oneobject5));
  }

  /**
   * 修改-传入修改后的全部数据oneobject5
   * @param oneobject5 oneobject5
   * @return XfR
   */
  @PutMapping("/oneobject5s/{id}")
  public XfR putUpdate(@RequestBody Oneobject5 oneobject5,@PathVariable Long id) {
      oneobject5.setId(id);
      return XfR.ok(oneobject5ServiceImpl.updateById(oneobject5));
  }

  /**
   * 修改-传入修改的数据oneobject5
   * @param oneobject5 oneobject5
   * @return XfR
   */
  @PatchMapping("/oneobject5s/{id}")
  public XfR patchUpdate(@RequestBody Oneobject5 oneobject5,@PathVariable Long id) {
      Oneobject5 uponeobject5 = oneobject5ServiceImpl.getById(id);
      if(uponeobject5 != null){
        uponeobject5 = ObjectCopyUtils.copyProperties(oneobject5,uponeobject5,true);
      }
      return XfR.ok(oneobject5ServiceImpl.updateById(uponeobject5));
  }

  /**
   * 通过id删除oneobject5
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oneobject5s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oneobject5ServiceImpl.removeById(id));
  }

  @PostMapping("/oneobject5s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oneobject5");
     params.put("request", condition);

     return XfR.ok(oneobject5ServiceImpl.querys(params));
  }

}
