package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Oneobject6;
import com.xforceplus.new20.service.IOneobject6Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * oneobject6前端控制器
 *
 * @author ultraman
 * @date 2023-05-22
 */
@RestController
public class Oneobject6Controller {

  @Autowired
  private IOneobject6Service oneobject6ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param oneobject6 oneobject6
   * @return
   */
  @GetMapping("/oneobject6s" )
  public XfR getOneobject6s(XfPage page, Oneobject6 oneobject6) {
    return XfR.ok(oneobject6ServiceImpl.page(page, Wrappers.query(oneobject6)));
  }

  /**
   * 通过id查询oneobject6
   * @param  id
   * @return XfR
   */
  @GetMapping("/oneobject6s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(oneobject6ServiceImpl.getById(id));
  }

  /**
   * 新增oneobject6
   * @param oneobject6 oneobject6
   * @return XfR
   */
  @PostMapping("/oneobject6s")
  public XfR save(@RequestBody Oneobject6 oneobject6) {
     return XfR.ok(oneobject6ServiceImpl.save(oneobject6));
  }

  /**
   * 修改-传入修改后的全部数据oneobject6
   * @param oneobject6 oneobject6
   * @return XfR
   */
  @PutMapping("/oneobject6s/{id}")
  public XfR putUpdate(@RequestBody Oneobject6 oneobject6,@PathVariable Long id) {
      oneobject6.setId(id);
      return XfR.ok(oneobject6ServiceImpl.updateById(oneobject6));
  }

  /**
   * 修改-传入修改的数据oneobject6
   * @param oneobject6 oneobject6
   * @return XfR
   */
  @PatchMapping("/oneobject6s/{id}")
  public XfR patchUpdate(@RequestBody Oneobject6 oneobject6,@PathVariable Long id) {
      Oneobject6 uponeobject6 = oneobject6ServiceImpl.getById(id);
      if(uponeobject6 != null){
        uponeobject6 = ObjectCopyUtils.copyProperties(oneobject6,uponeobject6,true);
      }
      return XfR.ok(oneobject6ServiceImpl.updateById(uponeobject6));
  }

  /**
   * 通过id删除oneobject6
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/oneobject6s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(oneobject6ServiceImpl.removeById(id));
  }

  @PostMapping("/oneobject6s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oneobject6");
     params.put("request", condition);

     return XfR.ok(oneobject6ServiceImpl.querys(params));
  }

}
