package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Yace001;
import com.xforceplus.new20.service.IYace001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * yace001前端控制器
 *
 * @author ultraman
 * @date 2023-05-22
 */
@RestController
public class Yace001Controller {

  @Autowired
  private IYace001Service yace001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param yace001 yace001
   * @return
   */
  @GetMapping("/yace001s" )
  public XfR getYace001s(XfPage page, Yace001 yace001) {
    return XfR.ok(yace001ServiceImpl.page(page, Wrappers.query(yace001)));
  }

  /**
   * 通过id查询yace001
   * @param  id
   * @return XfR
   */
  @GetMapping("/yace001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(yace001ServiceImpl.getById(id));
  }

  /**
   * 新增yace001
   * @param yace001 yace001
   * @return XfR
   */
  @PostMapping("/yace001s")
  public XfR save(@RequestBody Yace001 yace001) {
     return XfR.ok(yace001ServiceImpl.save(yace001));
  }

  /**
   * 修改-传入修改后的全部数据yace001
   * @param yace001 yace001
   * @return XfR
   */
  @PutMapping("/yace001s/{id}")
  public XfR putUpdate(@RequestBody Yace001 yace001,@PathVariable Long id) {
      yace001.setId(id);
      return XfR.ok(yace001ServiceImpl.updateById(yace001));
  }

  /**
   * 修改-传入修改的数据yace001
   * @param yace001 yace001
   * @return XfR
   */
  @PatchMapping("/yace001s/{id}")
  public XfR patchUpdate(@RequestBody Yace001 yace001,@PathVariable Long id) {
      Yace001 upyace001 = yace001ServiceImpl.getById(id);
      if(upyace001 != null){
        upyace001 = ObjectCopyUtils.copyProperties(yace001,upyace001,true);
      }
      return XfR.ok(yace001ServiceImpl.updateById(upyace001));
  }

  /**
   * 通过id删除yace001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/yace001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(yace001ServiceImpl.removeById(id));
  }

  @PostMapping("/yace001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "yace001");
     params.put("request", condition);

     return XfR.ok(yace001ServiceImpl.querys(params));
  }

}
