package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Zilei4;
import com.xforceplus.new20.service.IZilei4Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * zilei4前端控制器
 *
 * @author ultraman
 * @date 2023-05-22
 */
@RestController
public class Zilei4Controller {

  @Autowired
  private IZilei4Service zilei4ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zilei4 zilei4
   * @return
   */
  @GetMapping("/zilei4s" )
  public XfR getZilei4s(XfPage page, Zilei4 zilei4) {
    return XfR.ok(zilei4ServiceImpl.page(page, Wrappers.query(zilei4)));
  }

  /**
   * 通过id查询zilei4
   * @param  id
   * @return XfR
   */
  @GetMapping("/zilei4s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zilei4ServiceImpl.getById(id));
  }

  /**
   * 新增zilei4
   * @param zilei4 zilei4
   * @return XfR
   */
  @PostMapping("/zilei4s")
  public XfR save(@RequestBody Zilei4 zilei4) {
     return XfR.ok(zilei4ServiceImpl.save(zilei4));
  }

  /**
   * 修改-传入修改后的全部数据zilei4
   * @param zilei4 zilei4
   * @return XfR
   */
  @PutMapping("/zilei4s/{id}")
  public XfR putUpdate(@RequestBody Zilei4 zilei4,@PathVariable Long id) {
      zilei4.setId(id);
      return XfR.ok(zilei4ServiceImpl.updateById(zilei4));
  }

  /**
   * 修改-传入修改的数据zilei4
   * @param zilei4 zilei4
   * @return XfR
   */
  @PatchMapping("/zilei4s/{id}")
  public XfR patchUpdate(@RequestBody Zilei4 zilei4,@PathVariable Long id) {
      Zilei4 upzilei4 = zilei4ServiceImpl.getById(id);
      if(upzilei4 != null){
        upzilei4 = ObjectCopyUtils.copyProperties(zilei4,upzilei4,true);
      }
      return XfR.ok(zilei4ServiceImpl.updateById(upzilei4));
  }

  /**
   * 通过id删除zilei4
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zilei4s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zilei4ServiceImpl.removeById(id));
  }

  @PostMapping("/zilei4s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zilei4");
     params.put("request", condition);

     return XfR.ok(zilei4ServiceImpl.querys(params));
  }

}
