package com.xforceplus.new20.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.new20.entity.Zilei6;
import com.xforceplus.new20.service.IZilei6Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ziel6前端控制器
 *
 * @author ultraman
 * @date 2023-05-22
 */
@RestController
public class Zilei6Controller {

  @Autowired
  private IZilei6Service zilei6ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zilei6 ziel6
   * @return
   */
  @GetMapping("/zilei6s" )
  public XfR getZilei6s(XfPage page, Zilei6 zilei6) {
    return XfR.ok(zilei6ServiceImpl.page(page, Wrappers.query(zilei6)));
  }

  /**
   * 通过id查询ziel6
   * @param  id
   * @return XfR
   */
  @GetMapping("/zilei6s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zilei6ServiceImpl.getById(id));
  }

  /**
   * 新增ziel6
   * @param zilei6 ziel6
   * @return XfR
   */
  @PostMapping("/zilei6s")
  public XfR save(@RequestBody Zilei6 zilei6) {
     return XfR.ok(zilei6ServiceImpl.save(zilei6));
  }

  /**
   * 修改-传入修改后的全部数据ziel6
   * @param zilei6 ziel6
   * @return XfR
   */
  @PutMapping("/zilei6s/{id}")
  public XfR putUpdate(@RequestBody Zilei6 zilei6,@PathVariable Long id) {
      zilei6.setId(id);
      return XfR.ok(zilei6ServiceImpl.updateById(zilei6));
  }

  /**
   * 修改-传入修改的数据ziel6
   * @param zilei6 ziel6
   * @return XfR
   */
  @PatchMapping("/zilei6s/{id}")
  public XfR patchUpdate(@RequestBody Zilei6 zilei6,@PathVariable Long id) {
      Zilei6 upzilei6 = zilei6ServiceImpl.getById(id);
      if(upzilei6 != null){
        upzilei6 = ObjectCopyUtils.copyProperties(zilei6,upzilei6,true);
      }
      return XfR.ok(zilei6ServiceImpl.updateById(upzilei6));
  }

  /**
   * 通过id删除ziel6
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zilei6s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zilei6ServiceImpl.removeById(id));
  }

  @PostMapping("/zilei6s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zilei6");
     params.put("request", condition);

     return XfR.ok(zilei6ServiceImpl.querys(params));
  }

}
