package com.xforceplus.ultramanaudit.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author wangzheng
 * @date 2020-09-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanaudit.entity.Opfield;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "op-bpm")
public interface OpfieldFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/opfield/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param opfield ${table.comment}
   * @return R
   */
  @PostMapping("/opfield/add")
  public R save(@RequestBody Opfield opfield);

  /**
   * 修改${table.comment}
   * @param opfield ${table.comment}
   * @return R
   */
  @PostMapping("/opfield/update")
  public R updateById(@RequestBody Opfield opfield);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/opfield/del/{id}" )
  public R removeById(@PathVariable Long id);

}