package com.xforceplus.openapirapi.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2022-12-07
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.openapirapi.entity.TaxMessageStatistics;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "openapi-rapi")
public interface TaxMessageStatisticsFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/taxMessageStatistics/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param taxMessageStatistics ${table.comment}
   * @return R
   */
  @PostMapping("/taxMessageStatistics/add")
  public R save(@RequestBody TaxMessageStatistics taxMessageStatistics);

  /**
   * 修改${table.comment}
   * @param taxMessageStatistics ${table.comment}
   * @return R
   */
  @PostMapping("/taxMessageStatistics/update")
  public R updateById(@RequestBody TaxMessageStatistics taxMessageStatistics);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/taxMessageStatistics/del/{id}" )
  public R removeById(@PathVariable Long id);

}