package com.xforceplus.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 低频对账状态
 * </p>
 *
 * @author ultraman
 * @since 2023-04-19
 */
public enum LfStatus {

    _1("1", "对账通过"),
    _2("2", "对账中"),
    _3("3", "对账不一致"),
    _4("4", "税局受理中"),
    _5("5", "税局受理失败"),
    _6("6", "未开通同步服务"),
    _7("7", "未知异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    LfStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LfStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
