package com.xforceplus.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 管理状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-21
 */
public enum ManageStatus {

    _1("1", "正常"),
    _0("0", "非正常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ManageStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ManageStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
