package com.xforceplus.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 服务类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-26
 */
public enum ServiceType {

    AR("AR", "销项"),
    AP("AP", "进项");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ServiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ServiceType fromCode(String code){
        switch(code) {
            case "AR":
                return AR;
            case "AP":
                return AP;
            default:
                return null;
        }
    }
}
