package com.xforceplus.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单明细状态
 * </p>
 *
 * @author ultraman
 * @since 2023-09-05
 */
public enum BusinessListDetailStatus {

    _1("1", "正常"),
    _2("2", "作废"),
    _3("3", "开票已提交"),
    _4("4", "已开票"),
    _5("5", "已退回"),
    _9("9", "删除");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BusinessListDetailStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessListDetailStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
