package com.xforceplus.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 任务类型
 * </p>
 *
 * @author ultraman
 * @since 2023-09-05
 */
public enum TaskType {

    VERIFY("VERIFY", "验真"),
    RECOGNITION("RECOGNITION", "识别"),
    VERIFY_AND_RECOGNITION("VERIFY_AND_RECOGNITION", "识别并验真"),
    AGGREGATE_AND_RECOGNITION("AGGREGATE_AND_RECOGNITION", "文件聚合识别"),
    PDF_TO_IMAGE("PDF_TO_IMAGE", " pdf 转图片"),
    AGGREGATE_AND_RECOGNITION_MULTIPLE("AGGREGATE_AND_RECOGNITION_MULTIPLE", "文件聚合多票识别"),
    AGGREGATE_AND_RECOGNITION_ONE("AGGREGATE_AND_RECOGNITION_ONE", "文件聚合单票识别"),
    PDF_AGGREGATE_AND_RECOGNITION_VERIFY_IMAGE("PDF_AGGREGATE_AND_RECOGNITION_VERIFY_IMAGE", "pdf聚合验签识别转换"),
    PDF_AGGREGATE_AND_RECOGNITION("PDF_AGGREGATE_AND_RECOGNITION", "pdf聚合识别"),
    PDF_AGGREGATE_AND_VERIFY("PDF_AGGREGATE_AND_VERIFY", "pdf聚合验签"),
    PDF_AGGREGATE_AND_IMAGE("PDF_AGGREGATE_AND_IMAGE", "pdf聚合转图片");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaskType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskType fromCode(String code){
        switch(code) {
            case "VERIFY":
                return VERIFY;
            case "RECOGNITION":
                return RECOGNITION;
            case "VERIFY_AND_RECOGNITION":
                return VERIFY_AND_RECOGNITION;
            case "AGGREGATE_AND_RECOGNITION":
                return AGGREGATE_AND_RECOGNITION;
            case "PDF_TO_IMAGE":
                return PDF_TO_IMAGE;
            case "AGGREGATE_AND_RECOGNITION_MULTIPLE":
                return AGGREGATE_AND_RECOGNITION_MULTIPLE;
            case "AGGREGATE_AND_RECOGNITION_ONE":
                return AGGREGATE_AND_RECOGNITION_ONE;
            case "PDF_AGGREGATE_AND_RECOGNITION_VERIFY_IMAGE":
                return PDF_AGGREGATE_AND_RECOGNITION_VERIFY_IMAGE;
            case "PDF_AGGREGATE_AND_RECOGNITION":
                return PDF_AGGREGATE_AND_RECOGNITION;
            case "PDF_AGGREGATE_AND_VERIFY":
                return PDF_AGGREGATE_AND_VERIFY;
            case "PDF_AGGREGATE_AND_IMAGE":
                return PDF_AGGREGATE_AND_IMAGE;
            default:
                return null;
        }
    }
}
