package com.xforceplus.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 三方对账状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-18
 */
public enum ThreePartyCheckStatus {

    _0("0", "税局=平台=属地"),
    _1("1", "税局=平台≠属地"),
    _2("2", "税局≠平台=属地"),
    _3("3", "税局≠平台≠属地");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ThreePartyCheckStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ThreePartyCheckStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
