package com.xforceplus.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * apad_manage_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-23
 */
public enum ApadManageStatus {

    _01("01", "正常"),
    _03("03", "疑点发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ApadManageStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApadManageStatus fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "03":
                return _03;
            default:
                return null;
        }
    }
}
