package com.xforceplus.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * llm
 * </p>
 *
 * @author ultraman
 * @since 2024-07-23
 */
public enum Llm {

    BAICHUAN("Baichuan", "百川大模型"),
    KIMI("Kimi", "Kimi 大模型"),
    BAILIAN("Bailian", "百炼平台");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Llm(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Llm fromCode(String code){
        switch(code) {
            case "Baichuan":
                return BAICHUAN;
            case "Kimi":
                return KIMI;
            case "Bailian":
                return BAILIAN;
            default:
                return null;
        }
    }
}
