package com.xforceplus.openapirapi.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 电子发票（航空运输电子客票行程单）
 * </p>
 *
 * @author ultraman
 * @since 2024-07-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ETicketItinerary implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务类型
   */
  @TableField("businessType")
  private String businessType;

  /**
   * 姓名
   */
  @TableField("nameOfPassenger")
  private String nameOfPassenger;

  /**
   * 证件号
   */
  @TableField("idNumber")
  private String idNumber;

  /**
   * 电子客票号
   */
  @TableField("eticketNo")
  private String eticketNo;

  /**
   * 航班信息
   */
  @TableField("flightMsg")
  private String flightMsg;

  /**
   * 国内国际标识
   */
  @TableField("ionterIde")
  private String ionterIde;

  /**
   * GP单号
   */
  @TableField("gpNo")
  private String gpNo;

  /**
   * 签注
   */
  private String notes;

  /**
   * 提示信息
   */
  private String prompt;

  /**
   * 保险费
   */
  private String insurance;

  /**
   * 销售网点代码
   */
  @TableField("agentCode")
  private String agentCode;

  /**
   * 填开单位
   */
  @TableField("issuedBy")
  private String issuedBy;

  /**
   * 填开日期
   */
  @TableField("dateOfIssue")
  private String dateOfIssue;

  /**
   * 票价
   */
  private String fare;

  /**
   * 燃油附加费
   */
  @TableField("fuelSurcharge")
  private String fuelSurcharge;

  /**
   * 民航发展基金
   */
  @TableField("caacDevelopmentFund")
  private String caacDevelopmentFund;

  /**
   * 其他税费
   */
  private String tax;

  /**
   * 合计
   */
  private String total;

  /**
   * 增值税税额
   */
  @TableField("taxAmountStr")
  private String taxAmountStr;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 校验码
   */
  @TableField("checkCode")
  private String checkCode;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("businessType", businessType);
      map.put("nameOfPassenger", nameOfPassenger);
      map.put("idNumber", idNumber);
      map.put("eticketNo", eticketNo);
      map.put("flightMsg", flightMsg);
      map.put("ionterIde", ionterIde);
      map.put("gpNo", gpNo);
      map.put("notes", notes);
      map.put("prompt", prompt);
      map.put("insurance", insurance);
      map.put("agentCode", agentCode);
      map.put("issuedBy", issuedBy);
      map.put("dateOfIssue", dateOfIssue);
      map.put("fare", fare);
      map.put("fuelSurcharge", fuelSurcharge);
      map.put("caacDevelopmentFund", caacDevelopmentFund);
      map.put("tax", tax);
      map.put("total", total);
      map.put("taxAmountStr", taxAmountStr);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("checkCode", checkCode);
      map.put("taxRate", taxRate);

      return map;
  }

  public static ETicketItinerary fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ETicketItinerary entity = new ETicketItinerary();
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nameOfPassenger")) {
      Object obj = map.get("nameOfPassenger");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNameOfPassenger((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("idNumber")) {
      Object obj = map.get("idNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIdNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("eticketNo")) {
      Object obj = map.get("eticketNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEticketNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flightMsg")) {
      Object obj = map.get("flightMsg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlightMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ionterIde")) {
      Object obj = map.get("ionterIde");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIonterIde((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gpNo")) {
      Object obj = map.get("gpNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("notes")) {
      Object obj = map.get("notes");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNotes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prompt")) {
      Object obj = map.get("prompt");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrompt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("insurance")) {
      Object obj = map.get("insurance");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInsurance((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentCode")) {
      Object obj = map.get("agentCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issuedBy")) {
      Object obj = map.get("issuedBy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssuedBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dateOfIssue")) {
      Object obj = map.get("dateOfIssue");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDateOfIssue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fare")) {
      Object obj = map.get("fare");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFare((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fuelSurcharge")) {
      Object obj = map.get("fuelSurcharge");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFuelSurcharge((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("caacDevelopmentFund")) {
      Object obj = map.get("caacDevelopmentFund");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCaacDevelopmentFund((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax")) {
      Object obj = map.get("tax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total")) {
      Object obj = map.get("total");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTotal((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmountStr")) {
      Object obj = map.get("taxAmountStr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxAmountStr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("nameOfPassenger")) {
      Object obj = map.get("nameOfPassenger");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNameOfPassenger((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("idNumber")) {
      Object obj = map.get("idNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIdNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("eticketNo")) {
      Object obj = map.get("eticketNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEticketNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flightMsg")) {
      Object obj = map.get("flightMsg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlightMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ionterIde")) {
      Object obj = map.get("ionterIde");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIonterIde((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gpNo")) {
      Object obj = map.get("gpNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGpNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("notes")) {
      Object obj = map.get("notes");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNotes((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("prompt")) {
      Object obj = map.get("prompt");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrompt((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("insurance")) {
      Object obj = map.get("insurance");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInsurance((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("agentCode")) {
      Object obj = map.get("agentCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAgentCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issuedBy")) {
      Object obj = map.get("issuedBy");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssuedBy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dateOfIssue")) {
      Object obj = map.get("dateOfIssue");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDateOfIssue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fare")) {
      Object obj = map.get("fare");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFare((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fuelSurcharge")) {
      Object obj = map.get("fuelSurcharge");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFuelSurcharge((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("caacDevelopmentFund")) {
      Object obj = map.get("caacDevelopmentFund");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCaacDevelopmentFund((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax")) {
      Object obj = map.get("tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("total")) {
      Object obj = map.get("total");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTotal((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxAmountStr")) {
      Object obj = map.get("taxAmountStr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxAmountStr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
  }
}
