package com.xforceplus.openapirapi.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 电子发票（铁路电子客票）
 * </p>
 *
 * @author ultraman
 * @since 2024-07-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ETicketTrain implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务类型
   */
  @TableField("businessType")
  private String businessType;

  /**
   * 姓名
   */
  @TableField("nameOfPassenger")
  private String nameOfPassenger;

  /**
   * 证件号
   */
  @TableField("idNumber")
  private String idNumber;

  /**
   * 电子客票号
   */
  @TableField("eticketNo")
  private String eticketNo;

  /**
   * 出发站
   */
  private String from;

  /**
   * 到达站
   */
  private String to;

  /**
   * 车次
   */
  @TableField("trainNumber")
  private String trainNumber;

  /**
   * 乘车日期
   */
  private String date;

  /**
   * 出发时间
   */
  @TableField("departureTime")
  private String departureTime;

  /**
   * 席别
   */
  @TableField("railwaySeats")
  private String railwaySeats;

  /**
   * 车厢
   */
  @TableField("railwayCarriage")
  private String railwayCarriage;

  /**
   * 席位
   */
  private String seat;

  /**
   * 空调特征
   */
  @TableField("airConditioning")
  private String airConditioning;

  /**
   * 原票票价
   */
  @TableField("originalPrice")
  private String originalPrice;

  /**
   * 已退金额
   */
  @TableField("refundedAmount")
  private String refundedAmount;

  /**
   * 特殊备注
   */
  @TableField("specialNotes")
  private String specialNotes;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 票种
   */
  @TableField("ticketType")
  private String ticketType;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("businessType", businessType);
      map.put("nameOfPassenger", nameOfPassenger);
      map.put("idNumber", idNumber);
      map.put("eticketNo", eticketNo);
      map.put("from", from);
      map.put("to", to);
      map.put("trainNumber", trainNumber);
      map.put("date", date);
      map.put("departureTime", departureTime);
      map.put("railwaySeats", railwaySeats);
      map.put("railwayCarriage", railwayCarriage);
      map.put("seat", seat);
      map.put("airConditioning", airConditioning);
      map.put("originalPrice", originalPrice);
      map.put("refundedAmount", refundedAmount);
      map.put("specialNotes", specialNotes);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("ticketType", ticketType);

      return map;
  }

  public static ETicketTrain fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ETicketTrain entity = new ETicketTrain();
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nameOfPassenger")) {
      Object obj = map.get("nameOfPassenger");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNameOfPassenger((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("idNumber")) {
      Object obj = map.get("idNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIdNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("eticketNo")) {
      Object obj = map.get("eticketNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEticketNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("from")) {
      Object obj = map.get("from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("to")) {
      Object obj = map.get("to");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trainNumber")) {
      Object obj = map.get("trainNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTrainNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("date")) {
      Object obj = map.get("date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departureTime")) {
      Object obj = map.get("departureTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDepartureTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("railwaySeats")) {
      Object obj = map.get("railwaySeats");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRailwaySeats((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("railwayCarriage")) {
      Object obj = map.get("railwayCarriage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRailwayCarriage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seat")) {
      Object obj = map.get("seat");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSeat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("airConditioning")) {
      Object obj = map.get("airConditioning");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAirConditioning((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalPrice")) {
      Object obj = map.get("originalPrice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refundedAmount")) {
      Object obj = map.get("refundedAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundedAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialNotes")) {
      Object obj = map.get("specialNotes");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialNotes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticketType")) {
      Object obj = map.get("ticketType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTicketType((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("nameOfPassenger")) {
      Object obj = map.get("nameOfPassenger");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNameOfPassenger((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("idNumber")) {
      Object obj = map.get("idNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIdNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("eticketNo")) {
      Object obj = map.get("eticketNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEticketNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("from")) {
      Object obj = map.get("from");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFrom((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("to")) {
      Object obj = map.get("to");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trainNumber")) {
      Object obj = map.get("trainNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTrainNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("date")) {
      Object obj = map.get("date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("departureTime")) {
      Object obj = map.get("departureTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDepartureTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("railwaySeats")) {
      Object obj = map.get("railwaySeats");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRailwaySeats((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("railwayCarriage")) {
      Object obj = map.get("railwayCarriage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRailwayCarriage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seat")) {
      Object obj = map.get("seat");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSeat((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("airConditioning")) {
      Object obj = map.get("airConditioning");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAirConditioning((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originalPrice")) {
      Object obj = map.get("originalPrice");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalPrice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refundedAmount")) {
      Object obj = map.get("refundedAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundedAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specialNotes")) {
      Object obj = map.get("specialNotes");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialNotes((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticketType")) {
      Object obj = map.get("ticketType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTicketType((String)obj);
        }
      } else {
      }
    }
  }
}
