package com.xforceplus.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.openapirapi.entity.BaseNonVat;
import com.xforceplus.openapirapi.service.IBaseNonVatService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-02-08
 */
@RestController
public class BaseNonVatController {

  @Autowired
  private IBaseNonVatService baseNonVatServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param baseNonVat ${table.comment}
   * @return
   */
  @GetMapping("/basenonvats" )
  public XfR getBaseNonVats(XfPage page, BaseNonVat baseNonVat) {
    return XfR.ok(baseNonVatServiceImpl.page(page, Wrappers.query(baseNonVat)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/basenonvats/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(baseNonVatServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param baseNonVat ${table.comment}
   * @return XfR
   */
  @PostMapping("/basenonvats")
  public XfR save(@RequestBody BaseNonVat baseNonVat) {
     return XfR.ok(baseNonVatServiceImpl.save(baseNonVat));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param baseNonVat ${table.comment}
   * @return XfR
   */
  @PutMapping("/basenonvats/{id}")
  public XfR putUpdate(@RequestBody BaseNonVat baseNonVat,@PathVariable Long id) {
      baseNonVat.setId(id);
      return XfR.ok(baseNonVatServiceImpl.updateById(baseNonVat));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param baseNonVat ${table.comment}
   * @return XfR
   */
  @PatchMapping("/basenonvats/{id}")
  public XfR patchUpdate(@RequestBody BaseNonVat baseNonVat,@PathVariable Long id) {
      BaseNonVat upbaseNonVat = baseNonVatServiceImpl.getById(id);
      if(upbaseNonVat != null){
        upbaseNonVat = ObjectCopyUtils.copyProperties(baseNonVat,upbaseNonVat,true);
      }
      return XfR.ok(baseNonVatServiceImpl.updateById(upbaseNonVat));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/basenonvats/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(baseNonVatServiceImpl.removeById(id));
  }

  @PostMapping("/basenonvats/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "base_non_vat");
     params.put("request", condition);

     return XfR.ok(baseNonVatServiceImpl.querys(params));
  }

}
