package com.xforceplus.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.openapirapi.entity.TicketPlane;
import com.xforceplus.openapirapi.service.ITicketPlaneService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-23
 */
@RestController
public class TicketPlaneController {

  @Autowired
  private ITicketPlaneService ticketPlaneServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketPlane ${table.comment}
   * @return
   */
  @GetMapping("/ticketplanes" )
  public XfR getTicketPlanes(XfPage page, TicketPlane ticketPlane) {
    return XfR.ok(ticketPlaneServiceImpl.page(page, Wrappers.query(ticketPlane)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketplanes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketPlaneServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketPlane ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketplanes")
  public XfR save(@RequestBody TicketPlane ticketPlane) {
     return XfR.ok(ticketPlaneServiceImpl.save(ticketPlane));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketPlane ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketplanes/{id}")
  public XfR putUpdate(@RequestBody TicketPlane ticketPlane,@PathVariable Long id) {
      ticketPlane.setId(id);
      return XfR.ok(ticketPlaneServiceImpl.updateById(ticketPlane));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketPlane ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketplanes/{id}")
  public XfR patchUpdate(@RequestBody TicketPlane ticketPlane,@PathVariable Long id) {
      TicketPlane upticketPlane = ticketPlaneServiceImpl.getById(id);
      if(upticketPlane != null){
        upticketPlane = ObjectCopyUtils.copyProperties(ticketPlane,upticketPlane,true);
      }
      return XfR.ok(ticketPlaneServiceImpl.updateById(upticketPlane));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketplanes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketPlaneServiceImpl.removeById(id));
  }

  @PostMapping("/ticketplanes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_plane");
     params.put("request", condition);

     return XfR.ok(ticketPlaneServiceImpl.querys(params));
  }

}
