package com.xforceplus.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.openapirapi.entity.FailAggregateInvoice;
import com.xforceplus.openapirapi.service.IFailAggregateInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-27
 */
@RestController
public class FailAggregateInvoiceController {

  @Autowired
  private IFailAggregateInvoiceService failAggregateInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param failAggregateInvoice ${table.comment}
   * @return
   */
  @GetMapping("/failaggregateinvoices" )
  public XfR getFailAggregateInvoices(XfPage page, FailAggregateInvoice failAggregateInvoice) {
    return XfR.ok(failAggregateInvoiceServiceImpl.page(page, Wrappers.query(failAggregateInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/failaggregateinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(failAggregateInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param failAggregateInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/failaggregateinvoices")
  public XfR save(@RequestBody FailAggregateInvoice failAggregateInvoice) {
     return XfR.ok(failAggregateInvoiceServiceImpl.save(failAggregateInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param failAggregateInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/failaggregateinvoices/{id}")
  public XfR putUpdate(@RequestBody FailAggregateInvoice failAggregateInvoice,@PathVariable Long id) {
      failAggregateInvoice.setId(id);
      return XfR.ok(failAggregateInvoiceServiceImpl.updateById(failAggregateInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param failAggregateInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/failaggregateinvoices/{id}")
  public XfR patchUpdate(@RequestBody FailAggregateInvoice failAggregateInvoice,@PathVariable Long id) {
      FailAggregateInvoice upfailAggregateInvoice = failAggregateInvoiceServiceImpl.getById(id);
      if(upfailAggregateInvoice != null){
        upfailAggregateInvoice = ObjectCopyUtils.copyProperties(failAggregateInvoice,upfailAggregateInvoice,true);
      }
      return XfR.ok(failAggregateInvoiceServiceImpl.updateById(upfailAggregateInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/failaggregateinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(failAggregateInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/failaggregateinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fail_aggregate_invoice");
     params.put("request", condition);

     return XfR.ok(failAggregateInvoiceServiceImpl.querys(params));
  }

}
