package com.xforceplus.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.openapirapi.entity.FilterTicketBus;
import com.xforceplus.openapirapi.service.IFilterTicketBusService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-01-04
 */
@RestController
public class FilterTicketBusController {

  @Autowired
  private IFilterTicketBusService filterTicketBusServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param filterTicketBus ${table.comment}
   * @return
   */
  @GetMapping("/filterticketbuss" )
  public XfR getFilterTicketBuss(XfPage page, FilterTicketBus filterTicketBus) {
    return XfR.ok(filterTicketBusServiceImpl.page(page, Wrappers.query(filterTicketBus)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/filterticketbuss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(filterTicketBusServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param filterTicketBus ${table.comment}
   * @return XfR
   */
  @PostMapping("/filterticketbuss")
  public XfR save(@RequestBody FilterTicketBus filterTicketBus) {
     return XfR.ok(filterTicketBusServiceImpl.save(filterTicketBus));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param filterTicketBus ${table.comment}
   * @return XfR
   */
  @PutMapping("/filterticketbuss/{id}")
  public XfR putUpdate(@RequestBody FilterTicketBus filterTicketBus,@PathVariable Long id) {
      filterTicketBus.setId(id);
      return XfR.ok(filterTicketBusServiceImpl.updateById(filterTicketBus));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param filterTicketBus ${table.comment}
   * @return XfR
   */
  @PatchMapping("/filterticketbuss/{id}")
  public XfR patchUpdate(@RequestBody FilterTicketBus filterTicketBus,@PathVariable Long id) {
      FilterTicketBus upfilterTicketBus = filterTicketBusServiceImpl.getById(id);
      if(upfilterTicketBus != null){
        upfilterTicketBus = ObjectCopyUtils.copyProperties(filterTicketBus,upfilterTicketBus,true);
      }
      return XfR.ok(filterTicketBusServiceImpl.updateById(upfilterTicketBus));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/filterticketbuss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(filterTicketBusServiceImpl.removeById(id));
  }

  @PostMapping("/filterticketbuss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "filter_ticket_bus");
     params.put("request", condition);

     return XfR.ok(filterTicketBusServiceImpl.querys(params));
  }

}
