package com.xforceplus.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.openapirapi.entity.InvoiceChangedHistory;
import com.xforceplus.openapirapi.service.IInvoiceChangedHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-01-04
 */
@RestController
public class InvoiceChangedHistoryController {

  @Autowired
  private IInvoiceChangedHistoryService invoiceChangedHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceChangedHistory ${table.comment}
   * @return
   */
  @GetMapping("/invoicechangedhistorys" )
  public XfR getInvoiceChangedHistorys(XfPage page, InvoiceChangedHistory invoiceChangedHistory) {
    return XfR.ok(invoiceChangedHistoryServiceImpl.page(page, Wrappers.query(invoiceChangedHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicechangedhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceChangedHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceChangedHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicechangedhistorys")
  public XfR save(@RequestBody InvoiceChangedHistory invoiceChangedHistory) {
     return XfR.ok(invoiceChangedHistoryServiceImpl.save(invoiceChangedHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceChangedHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicechangedhistorys/{id}")
  public XfR putUpdate(@RequestBody InvoiceChangedHistory invoiceChangedHistory,@PathVariable Long id) {
      invoiceChangedHistory.setId(id);
      return XfR.ok(invoiceChangedHistoryServiceImpl.updateById(invoiceChangedHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceChangedHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicechangedhistorys/{id}")
  public XfR patchUpdate(@RequestBody InvoiceChangedHistory invoiceChangedHistory,@PathVariable Long id) {
      InvoiceChangedHistory upinvoiceChangedHistory = invoiceChangedHistoryServiceImpl.getById(id);
      if(upinvoiceChangedHistory != null){
        upinvoiceChangedHistory = ObjectCopyUtils.copyProperties(invoiceChangedHistory,upinvoiceChangedHistory,true);
      }
      return XfR.ok(invoiceChangedHistoryServiceImpl.updateById(upinvoiceChangedHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicechangedhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceChangedHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/invoicechangedhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_changed_history");
     params.put("request", condition);

     return XfR.ok(invoiceChangedHistoryServiceImpl.querys(params));
  }

}
