package com.xforceplus.phoenixkylinservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 运输工具种类
 * </p>
 *
 * @author ultraman
 * @since 2022-12-15
 */
public enum TransportationType {

    _01("01", "铁路运输"),
    _02("02", "公路运输"),
    _03("03", "水路运输"),
    _04("04", "航空运输"),
    _05("05", "管道运输");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TransportationType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TransportationType fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            default:
                return null;
        }
    }
}
