package com.xforceplus.phoenixkylinservice.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 3.0
 * </p>
 *
 * @author ultraman
 * @since 2022-12-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SellerInvoice3 implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 发票序列号主键
   */
  @TableField("invoiceId")
  private String invoiceId;

  /**
   * 预制发票序列号
   */
  @TableField("preInvoiceId")
  private String preInvoiceId;

  /**
   * 结算单序号
   */
  @TableField("settlementId")
  private String settlementId;

  /**
   * 结算单号（企业）
   */
  @TableField("settlementNo")
  private String settlementNo;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 全电发票号码
   */
  @TableField("allElectricInvoiceNo")
  private String allElectricInvoiceNo;

  /**
   * 销方租户代码
   */
  @TableField("sellerTenantCode")
  private String sellerTenantCode;

  /**
   * 销方租户公司编号
   */
  @TableField("sellerNo")
  private String sellerNo;

  /**
   * 购方租户定义的销方公司编号
   */
  @TableField("sellerNoFromPurchaser")
  private String sellerNoFromPurchaser;

  /**
   * 销方公司代码
   */
  @TableField("sellerCode")
  private String sellerCode;

  /**
   * 销方纳税人识别号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方地址电话
   */
  @TableField("sellerAddrTel")
  private String sellerAddrTel;

  /**
   * 销方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 销方电话
   */
  @TableField("sellerTel")
  private String sellerTel;

  /**
   * 销方银行名称账号
   */
  @TableField("sellerBankInfo")
  private String sellerBankInfo;

  /**
   * 销方银行名称
   */
  @TableField("sellerBankName")
  private String sellerBankName;

  /**
   * 销方银行账号
   */
  @TableField("sellerBankAccount")
  private String sellerBankAccount;

  /**
   * 购方租户代码
   */
  @TableField("purchaserTenantCode")
  private String purchaserTenantCode;

  /**
   * 购方租户公司编号
   */
  @TableField("purchaserNo")
  private String purchaserNo;

  /**
   * 销方租户定义的购方公司编号
   */
  @TableField("purchaserNoFromSeller")
  private String purchaserNoFromSeller;

  /**
   * 购方公司代码
   */
  @TableField("purchaserCode")
  private String purchaserCode;

  /**
   * 购方纳税人识别号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方地址电话
   */
  @TableField("purchaserAddrTel")
  private String purchaserAddrTel;

  /**
   * 购方地址
   */
  @TableField("purchaserAddress")
  private String purchaserAddress;

  /**
   * 购方电话
   */
  @TableField("purchaserTel")
  private String purchaserTel;

  /**
   * 购方银行名称账号
   */
  @TableField("purchaserBankInfo")
  private String purchaserBankInfo;

  /**
   * 购方银行名称
   */
  @TableField("purchaserBankName")
  private String purchaserBankName;

  /**
   * 购方银行账号
   */
  @TableField("purchaserBankAccount")
  private String purchaserBankAccount;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 发票开票日期
   */
  @TableField("paperDrewDate")
  private String paperDrewDate;

  /**
   * 发票来源1-抽取5-直连 7-回填
   */
  @TableField("invoiceOrig")
  private String invoiceOrig;

  /**
   * 二维码发票标记
   */
  @TableField("twoCodeFlag")
  private String twoCodeFlag;

  /**
   * 二维密文
   */
  @TableField("cipherTextTwoCode")
  private String cipherTextTwoCode;

  /**
   * 密文
   */
  @TableField("cipherText")
  private String cipherText;

  /**
   * 备注
   */
  private String remark;

  /**
   * 收款人姓名
   */
  @TableField("cashierName")
  private String cashierName;

  /**
   * 复核人姓名
   */
  @TableField("checkerName")
  private String checkerName;

  /**
   * 开票人姓名
   */
  @TableField("invoicerName")
  private String invoicerName;

  /**
   * 机器编码
   */
  @TableField("machineCode")
  private String machineCode;

  /**
   * 导入时间待确认
   */
  @TableField("importTime")
  private String importTime;

  /**
   * 导入操作账号待确认
   */
  @TableField("importUserId")
  private String importUserId;

  /**
   * 抽取时间
   */
  @TableField("drawoutTime")
  private String drawoutTime;

  /**
   * 抽取操作账号
   */
  @TableField("drawoutUserId")
  private String drawoutUserId;

  /**
   * 是否需要认证1-需要2-不需要
   */
  @TableField("isNeedAuth")
  private String isNeedAuth;

  /**
   * 运单号物流模块使用
   */
  @TableField("expressNo")
  private String expressNo;

  /**
   * 虚拟标志
   */
  @TableField("virtualFlag")
  private String virtualFlag;

  /**
   * 发票状态1-正常 0-作废 9-删除 7-重复警告
   */
  private String status;

  /**
   * 原发票号码
   */
  @TableField("originInvoiceNo")
  private String originInvoiceNo;

  /**
   * 原发票代码
   */
  @TableField("originInvoiceCode")
  private String originInvoiceCode;

  /**
   * 红字信息表编号
   */
  @TableField("redNotificationNo")
  private String redNotificationNo;

  /**
   * 红冲时间
   */
  @TableField("redTime")
  private String redTime;

  /**
   * 红冲状态1-待红冲2-待部分红冲3-红冲4-部分红冲
   */
  @TableField("redFlag")
  private String redFlag;

  /**
   * 发票明细生成方式
   */
  @TableField("invoiceItemMode")
  private String invoiceItemMode;

  /**
   * 处理标记
   */
  @TableField("processFlag")
  private String processFlag;

  /**
   * 处理备注
   */
  @TableField("processRemark")
  private String processRemark;

  /**
   * 抽取关联接口表id
   */
  @TableField("drawoutInterfaceId")
  private String drawoutInterfaceId;

  /**
   * 抽取状态
   */
  @TableField("drawoutStatus")
  private String drawoutStatus;

  /**
   * 电子发票标志1-电子发票
   */
  @TableField("electronicInvoiceFlag")
  private String electronicInvoiceFlag;

  /**
   * 系统来源
   */
  @TableField("systemOrig")
  private String systemOrig;

  /**
   * 销货清单文件打印标志（0-否,1-是）
   */
  @TableField("saleListFileFlag")
  private String saleListFileFlag;

  /**
   * 销货清单打印备注
   */
  @TableField("saleListFileRemark")
  private String saleListFileRemark;

  /**
   * 校验码
   */
  @TableField("checkCode")
  private String checkCode;

  /**
   * 适用业务单据类型
   */
  @TableField("businessBillType")
  private String businessBillType;

  /**
   * 是否已上传附件标志0-未上传1-已上传
   */
  @TableField("attachmentFlag")
  private String attachmentFlag;

  /**
   * 销项接口表ID
   */
  @TableField("invoiceInterfaceId")
  private String invoiceInterfaceId;

  /**
   * 协同类型0-非协同；1-协同；空-以票易通平台配置决定
   */
  @TableField("cooperateFlag")
  private String cooperateFlag;

  /**
   * 打印内容标志（0-打印单价和数量 1-不打印单价和数量，默认null）
   */
  @TableField("printContentFlag")
  private String printContentFlag;

  /**
   * 特殊扩展字段1待确认
   */
  @TableField("specialExt1")
  private String specialExt1;

  /**
   * 特殊扩展字段2待确认
   */
  @TableField("specialExt2")
  private String specialExt2;

  /**
   * 作废时间
   */
  @TableField("deposeTime")
  private String deposeTime;

  /**
   * 作废操作账号
   */
  @TableField("deposeUserId")
  private String deposeUserId;

  /**
   * 删除时间
   */
  @TableField("deleteTime")
  private String deleteTime;

  /**
   * 删除操作账号
   */
  @TableField("deleteUserId")
  private String deleteUserId;

  /**
   * 退回时间
   */
  @TableField("retreatTime")
  private String retreatTime;

  /**
   * 退回说明
   */
  @TableField("retreatRemark")
  private String retreatRemark;

  /**
   * 退回状态0：未退回；1：系统退回；2：购方退回
   */
  @TableField("retreatStatus")
  private String retreatStatus;

  /**
   * 平台预制发票正式信息回填时间
   */
  @TableField("createTime")
  private String createTime;

  /**
   * 平台预制发票正式信息回填操作账号
   */
  @TableField("createUserId")
  private String createUserId;

  /**
   * 更新账号
   */
  @TableField("updateUserId")
  private String updateUserId;

  /**
   * 修改时间
   */
  @TableField("updateTime")
  private String updateTime;

  /**
   * 处理状态1-正常 2-待处理 0-作废 
   */
  @TableField("handleStatus")
  private String handleStatus;

  /**
   * PDF路径
   */
  @TableField("pdfPath")
  private String pdfPath;

  /**
   * 运维状态1-运维状态
   */
  @TableField("opStatus")
  private String opStatus;

  /**
   * 进项发票序列号待确认
   */
  @TableField("purchaserInvoiceId")
  private String purchaserInvoiceId;

  /**
   * 处理状态 
   */
  @TableField("handleFlag")
  private String handleFlag;

  /**
   * 处理时间
   */
  @TableField("handleTime")
  private String handleTime;

  /**
   * 处理备注
   */
  @TableField("handleRemark")
  private String handleRemark;

  /**
   * 可疑标签（0：可疑，1：正常）
   */
  @TableField("isSureFlag")
  private String isSureFlag;

  /**
   * 可疑标注
   */
  @TableField("isSureRemark")
  private String isSureRemark;

  /**
   * 开票点名称
   */
  @TableField("makeOutUnitName")
  private String makeOutUnitName;

  /**
   * 开票点代码
   */
  @TableField("makeOutUnitCode")
  private String makeOutUnitCode;

  /**
   * 抵扣联影像路径
   */
  @TableField("scanDeductionImageUrl")
  private String scanDeductionImageUrl;

  /**
   * 发票联影像路径
   */
  @TableField("scanInvoiceImageUrl")
  private String scanInvoiceImageUrl;

  /**
   * 扩展字段1
   */
  private String ext1;

  /**
   * 扩展字段2
   */
  private String ext2;

  /**
   * 扩展字段3
   */
  private String ext3;

  /**
   * 扩展字段4
   */
  private String ext4;

  /**
   * 扩展字段5
   */
  private String ext5;

  /**
   * 扩展字段6
   */
  private String ext6;

  /**
   * 扩展字段7
   */
  private String ext7;

  /**
   * 扩展字段8
   */
  private String ext8;

  /**
   * 扩展字段9
   */
  private String ext9;

  /**
   * 扩展字段10
   */
  private String ext10;

  /**
   * 折扣模式： 0-归到价内 1-归到价外 2-汇总
   */
  @TableField("discountMode")
  private String discountMode;

  /**
   * 发票开具后自动发送邮件的邮箱
   */
  @TableField("reciveUser")
  private String reciveUser;

  /**
   * 税控终端码
   */
  @TableField("taxControlCode")
  private String taxControlCode;

  /**
   * 预作废状态：1-待作废 2-作废驳回 3-作废成功
   */
  @TableField("invalidateFlag")
  private String invalidateFlag;

  /**
   * 开具模式：client/server/blockchain
   */
  private String mode;

  /**
   * 开票机号
   */
  @TableField("machineNo")
  private String machineNo;

  /**
   * xml路径
   */
  @TableField("xmlUrl")
  private String xmlUrl;

  /**
   * ofd路径
   */
  @TableField("ofdUrl")
  private String ofdUrl;

  /**
   * img路径
   */
  @TableField("imgUrl")
  private String imgUrl;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceId", invoiceId);
      map.put("preInvoiceId", preInvoiceId);
      map.put("settlementId", settlementId);
      map.put("settlementNo", settlementNo);
      map.put("invoiceType", invoiceType);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("allElectricInvoiceNo", allElectricInvoiceNo);
      map.put("sellerTenantCode", sellerTenantCode);
      map.put("sellerNo", sellerNo);
      map.put("sellerNoFromPurchaser", sellerNoFromPurchaser);
      map.put("sellerCode", sellerCode);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerName", sellerName);
      map.put("sellerAddrTel", sellerAddrTel);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTel", sellerTel);
      map.put("sellerBankInfo", sellerBankInfo);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("purchaserTenantCode", purchaserTenantCode);
      map.put("purchaserNo", purchaserNo);
      map.put("purchaserNoFromSeller", purchaserNoFromSeller);
      map.put("purchaserCode", purchaserCode);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserName", purchaserName);
      map.put("purchaserAddrTel", purchaserAddrTel);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserBankInfo", purchaserBankInfo);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("taxRate", taxRate);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("paperDrewDate", paperDrewDate);
      map.put("invoiceOrig", invoiceOrig);
      map.put("twoCodeFlag", twoCodeFlag);
      map.put("cipherTextTwoCode", cipherTextTwoCode);
      map.put("cipherText", cipherText);
      map.put("remark", remark);
      map.put("cashierName", cashierName);
      map.put("checkerName", checkerName);
      map.put("invoicerName", invoicerName);
      map.put("machineCode", machineCode);
      map.put("importTime", importTime);
      map.put("importUserId", importUserId);
      map.put("drawoutTime", drawoutTime);
      map.put("drawoutUserId", drawoutUserId);
      map.put("isNeedAuth", isNeedAuth);
      map.put("expressNo", expressNo);
      map.put("virtualFlag", virtualFlag);
      map.put("status", status);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("redNotificationNo", redNotificationNo);
      map.put("redTime", redTime);
      map.put("redFlag", redFlag);
      map.put("invoiceItemMode", invoiceItemMode);
      map.put("processFlag", processFlag);
      map.put("processRemark", processRemark);
      map.put("drawoutInterfaceId", drawoutInterfaceId);
      map.put("drawoutStatus", drawoutStatus);
      map.put("electronicInvoiceFlag", electronicInvoiceFlag);
      map.put("systemOrig", systemOrig);
      map.put("saleListFileFlag", saleListFileFlag);
      map.put("saleListFileRemark", saleListFileRemark);
      map.put("checkCode", checkCode);
      map.put("businessBillType", businessBillType);
      map.put("attachmentFlag", attachmentFlag);
      map.put("invoiceInterfaceId", invoiceInterfaceId);
      map.put("cooperateFlag", cooperateFlag);
      map.put("printContentFlag", printContentFlag);
      map.put("specialExt1", specialExt1);
      map.put("specialExt2", specialExt2);
      map.put("deposeTime", deposeTime);
      map.put("deposeUserId", deposeUserId);
      map.put("deleteTime", deleteTime);
      map.put("deleteUserId", deleteUserId);
      map.put("retreatTime", retreatTime);
      map.put("retreatRemark", retreatRemark);
      map.put("retreatStatus", retreatStatus);
      map.put("createTime", createTime);
      map.put("createUserId", createUserId);
      map.put("updateUserId", updateUserId);
      map.put("updateTime", updateTime);
      map.put("handleStatus", handleStatus);
      map.put("pdfPath", pdfPath);
      map.put("opStatus", opStatus);
      map.put("purchaserInvoiceId", purchaserInvoiceId);
      map.put("handleFlag", handleFlag);
      map.put("handleTime", handleTime);
      map.put("handleRemark", handleRemark);
      map.put("isSureFlag", isSureFlag);
      map.put("isSureRemark", isSureRemark);
      map.put("makeOutUnitName", makeOutUnitName);
      map.put("makeOutUnitCode", makeOutUnitCode);
      map.put("scanDeductionImageUrl", scanDeductionImageUrl);
      map.put("scanInvoiceImageUrl", scanInvoiceImageUrl);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("discountMode", discountMode);
      map.put("reciveUser", reciveUser);
      map.put("taxControlCode", taxControlCode);
      map.put("invalidateFlag", invalidateFlag);
      map.put("mode", mode);
      map.put("machineNo", machineNo);
      map.put("xmlUrl", xmlUrl);
      map.put("ofdUrl", ofdUrl);
      map.put("imgUrl", imgUrl);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static SellerInvoice3 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SellerInvoice3 entity = new SellerInvoice3();
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preInvoiceId")) {
      Object obj = map.get("preInvoiceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPreInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementId")) {
      Object obj = map.get("settlementId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlementNo")) {
      Object obj = map.get("settlementNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allElectricInvoiceNo")) {
      Object obj = map.get("allElectricInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantCode")) {
      Object obj = map.get("sellerTenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNoFromPurchaser")) {
      Object obj = map.get("sellerNoFromPurchaser");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNoFromPurchaser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankInfo")) {
      Object obj = map.get("sellerBankInfo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTenantCode")) {
      Object obj = map.get("purchaserTenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNoFromSeller")) {
      Object obj = map.get("purchaserNoFromSeller");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNoFromSeller((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserCode")) {
      Object obj = map.get("purchaserCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddrTel")) {
      Object obj = map.get("purchaserAddrTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankInfo")) {
      Object obj = map.get("purchaserBankInfo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperDrewDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceOrig")) {
      Object obj = map.get("invoiceOrig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("twoCodeFlag")) {
      Object obj = map.get("twoCodeFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTwoCodeFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherTextTwoCode")) {
      Object obj = map.get("cipherTextTwoCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipherTextTwoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("importTime")) {
      Object obj = map.get("importTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImportTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("importUserId")) {
      Object obj = map.get("importUserId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImportUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("drawoutTime")) {
      Object obj = map.get("drawoutTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDrawoutTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("drawoutUserId")) {
      Object obj = map.get("drawoutUserId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDrawoutUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isNeedAuth")) {
      Object obj = map.get("isNeedAuth");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsNeedAuth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expressNo")) {
      Object obj = map.get("expressNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExpressNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("virtualFlag")) {
      Object obj = map.get("virtualFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVirtualFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redTime")) {
      Object obj = map.get("redTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redFlag")) {
      Object obj = map.get("redFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceItemMode")) {
      Object obj = map.get("invoiceItemMode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceItemMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("processFlag")) {
      Object obj = map.get("processFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcessFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("processRemark")) {
      Object obj = map.get("processRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcessRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("drawoutInterfaceId")) {
      Object obj = map.get("drawoutInterfaceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDrawoutInterfaceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("drawoutStatus")) {
      Object obj = map.get("drawoutStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDrawoutStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("electronicInvoiceFlag")) {
      Object obj = map.get("electronicInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setElectronicInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaleListFileFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saleListFileRemark")) {
      Object obj = map.get("saleListFileRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaleListFileRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessBillType")) {
      Object obj = map.get("businessBillType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attachmentFlag")) {
      Object obj = map.get("attachmentFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAttachmentFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceInterfaceId")) {
      Object obj = map.get("invoiceInterfaceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceInterfaceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cooperateFlag")) {
      Object obj = map.get("cooperateFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCooperateFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("printContentFlag")) {
      Object obj = map.get("printContentFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrintContentFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialExt1")) {
      Object obj = map.get("specialExt1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSpecialExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialExt2")) {
      Object obj = map.get("specialExt2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSpecialExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deposeTime")) {
      Object obj = map.get("deposeTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeposeTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deposeUserId")) {
      Object obj = map.get("deposeUserId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeposeUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deleteTime")) {
      Object obj = map.get("deleteTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deleteUserId")) {
      Object obj = map.get("deleteUserId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatTime")) {
      Object obj = map.get("retreatTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRetreatTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatRemark")) {
      Object obj = map.get("retreatRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRetreatRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatStatus")) {
      Object obj = map.get("retreatStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createTime")) {
      Object obj = map.get("createTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createUserId")) {
      Object obj = map.get("createUserId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("updateUserId")) {
      Object obj = map.get("updateUserId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("updateTime")) {
      Object obj = map.get("updateTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfPath")) {
      Object obj = map.get("pdfPath");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPdfPath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("opStatus")) {
      Object obj = map.get("opStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOpStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserInvoiceId")) {
      Object obj = map.get("purchaserInvoiceId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleFlag")) {
      Object obj = map.get("handleFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHandleFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleTime")) {
      Object obj = map.get("handleTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHandleTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handleRemark")) {
      Object obj = map.get("handleRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHandleRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isSureFlag")) {
      Object obj = map.get("isSureFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsSureFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isSureRemark")) {
      Object obj = map.get("isSureRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsSureRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeOutUnitName")) {
      Object obj = map.get("makeOutUnitName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMakeOutUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeOutUnitCode")) {
      Object obj = map.get("makeOutUnitCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMakeOutUnitCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scanDeductionImageUrl")) {
      Object obj = map.get("scanDeductionImageUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanDeductionImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scanInvoiceImageUrl")) {
      Object obj = map.get("scanInvoiceImageUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanInvoiceImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountMode")) {
      Object obj = map.get("discountMode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscountMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reciveUser")) {
      Object obj = map.get("reciveUser");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReciveUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxControlCode")) {
      Object obj = map.get("taxControlCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxControlCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invalidateFlag")) {
      Object obj = map.get("invalidateFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvalidateFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mode")) {
      Object obj = map.get("mode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machineNo")) {
      Object obj = map.get("machineNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMachineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xmlUrl")) {
      Object obj = map.get("xmlUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setXmlUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ofdUrl")) {
      Object obj = map.get("ofdUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOfdUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("imgUrl")) {
      Object obj = map.get("imgUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("preInvoiceId")) {
      Object obj = map.get("preInvoiceId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreInvoiceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementId")) {
      Object obj = map.get("settlementId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlementNo")) {
      Object obj = map.get("settlementNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("allElectricInvoiceNo")) {
      Object obj = map.get("allElectricInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAllElectricInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTenantCode")) {
      Object obj = map.get("sellerTenantCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerNoFromPurchaser")) {
      Object obj = map.get("sellerNoFromPurchaser");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNoFromPurchaser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankInfo")) {
      Object obj = map.get("sellerBankInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTenantCode")) {
      Object obj = map.get("purchaserTenantCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserNoFromSeller")) {
      Object obj = map.get("purchaserNoFromSeller");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserNoFromSeller((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserCode")) {
      Object obj = map.get("purchaserCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserAddrTel")) {
      Object obj = map.get("purchaserAddrTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankInfo")) {
      Object obj = map.get("purchaserBankInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaperDrewDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceOrig")) {
      Object obj = map.get("invoiceOrig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("twoCodeFlag")) {
      Object obj = map.get("twoCodeFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTwoCodeFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cipherTextTwoCode")) {
      Object obj = map.get("cipherTextTwoCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCipherTextTwoCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCipherText((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCashierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMachineCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("importTime")) {
      Object obj = map.get("importTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImportTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("importUserId")) {
      Object obj = map.get("importUserId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImportUserId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("drawoutTime")) {
      Object obj = map.get("drawoutTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDrawoutTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("drawoutUserId")) {
      Object obj = map.get("drawoutUserId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDrawoutUserId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isNeedAuth")) {
      Object obj = map.get("isNeedAuth");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsNeedAuth((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expressNo")) {
      Object obj = map.get("expressNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpressNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("virtualFlag")) {
      Object obj = map.get("virtualFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVirtualFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedNotificationNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redTime")) {
      Object obj = map.get("redTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redFlag")) {
      Object obj = map.get("redFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceItemMode")) {
      Object obj = map.get("invoiceItemMode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceItemMode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("processFlag")) {
      Object obj = map.get("processFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcessFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("processRemark")) {
      Object obj = map.get("processRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcessRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("drawoutInterfaceId")) {
      Object obj = map.get("drawoutInterfaceId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDrawoutInterfaceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("drawoutStatus")) {
      Object obj = map.get("drawoutStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDrawoutStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("electronicInvoiceFlag")) {
      Object obj = map.get("electronicInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setElectronicInvoiceFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSystemOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaleListFileFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("saleListFileRemark")) {
      Object obj = map.get("saleListFileRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSaleListFileRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessBillType")) {
      Object obj = map.get("businessBillType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessBillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attachmentFlag")) {
      Object obj = map.get("attachmentFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttachmentFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceInterfaceId")) {
      Object obj = map.get("invoiceInterfaceId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceInterfaceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cooperateFlag")) {
      Object obj = map.get("cooperateFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCooperateFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("printContentFlag")) {
      Object obj = map.get("printContentFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrintContentFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specialExt1")) {
      Object obj = map.get("specialExt1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specialExt2")) {
      Object obj = map.get("specialExt2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deposeTime")) {
      Object obj = map.get("deposeTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeposeTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deposeUserId")) {
      Object obj = map.get("deposeUserId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeposeUserId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deleteTime")) {
      Object obj = map.get("deleteTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deleteUserId")) {
      Object obj = map.get("deleteUserId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteUserId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retreatTime")) {
      Object obj = map.get("retreatTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRetreatTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retreatRemark")) {
      Object obj = map.get("retreatRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRetreatRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retreatStatus")) {
      Object obj = map.get("retreatStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRetreatStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createTime")) {
      Object obj = map.get("createTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createUserId")) {
      Object obj = map.get("createUserId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("updateUserId")) {
      Object obj = map.get("updateUserId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("updateTime")) {
      Object obj = map.get("updateTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("handleStatus")) {
      Object obj = map.get("handleStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHandleStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pdfPath")) {
      Object obj = map.get("pdfPath");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPdfPath((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("opStatus")) {
      Object obj = map.get("opStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOpStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserInvoiceId")) {
      Object obj = map.get("purchaserInvoiceId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserInvoiceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("handleFlag")) {
      Object obj = map.get("handleFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHandleFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("handleTime")) {
      Object obj = map.get("handleTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHandleTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("handleRemark")) {
      Object obj = map.get("handleRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHandleRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isSureFlag")) {
      Object obj = map.get("isSureFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsSureFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isSureRemark")) {
      Object obj = map.get("isSureRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsSureRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("makeOutUnitName")) {
      Object obj = map.get("makeOutUnitName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMakeOutUnitName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("makeOutUnitCode")) {
      Object obj = map.get("makeOutUnitCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMakeOutUnitCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("scanDeductionImageUrl")) {
      Object obj = map.get("scanDeductionImageUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setScanDeductionImageUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("scanInvoiceImageUrl")) {
      Object obj = map.get("scanInvoiceImageUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setScanInvoiceImageUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discountMode")) {
      Object obj = map.get("discountMode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscountMode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reciveUser")) {
      Object obj = map.get("reciveUser");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReciveUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxControlCode")) {
      Object obj = map.get("taxControlCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxControlCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invalidateFlag")) {
      Object obj = map.get("invalidateFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvalidateFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mode")) {
      Object obj = map.get("mode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("machineNo")) {
      Object obj = map.get("machineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMachineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("xmlUrl")) {
      Object obj = map.get("xmlUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setXmlUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ofdUrl")) {
      Object obj = map.get("ofdUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOfdUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("imgUrl")) {
      Object obj = map.get("imgUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImgUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
