package com.xforceplus.phoenixkylinservice.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-01-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceRealLeasehold implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 房屋产权证书/不动产权证号码
   */
  @TableField("realEstateNo")
  private String realEstateNo;

  /**
   * 不动产详细地址
   */
  @TableField("realEstateAddress")
  private String realEstateAddress;

  /**
   * 租赁期起
   */
  @TableField("leaseTermStart")
  private String leaseTermStart;

  /**
   * 租赁期止
   */
  @TableField("leaseTermEnd")
  private String leaseTermEnd;

  /**
   * 跨地市标志
   */
  @TableField("crossCitySign")
  private Boolean crossCitySign;

  /**
   * 面积单位
   */
  @TableField("areaUnit")
  private String areaUnit;

  /**
   * 单据流水号
   */
  private String pid;

  /**
   * 租户ID
   */
  @TableField("tenantCode")
  private String tenantCode;

  /**
   * 不动产地址
   */
  @TableField("realEstatePlace")
  private String realEstatePlace;

  /**
   * 来源关联ID
   */
  @TableField("sourceId")
  private String sourceId;

  /**
   * 来源系统
   */
  private String source;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 来源关联明细Id
   */
  @TableField("sourceItemId")
  private String sourceItemId;


  /**
   * 对一关联关系 关联对象 invSellerInvoice
   */
    private Long invoiceOneToManyRealLeaseholdId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("realEstateNo", realEstateNo);
      map.put("realEstateAddress", realEstateAddress);
      map.put("leaseTermStart", leaseTermStart);
      map.put("leaseTermEnd", leaseTermEnd);
      map.put("crossCitySign", crossCitySign);
      map.put("areaUnit", areaUnit);
      map.put("pid", pid);
      map.put("tenantCode", tenantCode);
      map.put("realEstatePlace", realEstatePlace);
      map.put("sourceId", sourceId);
      map.put("source", source);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("sourceItemId", sourceItemId);

       map.put("invoiceOneToManyRealLeasehold.id", invoiceOneToManyRealLeaseholdId);
      return map;
  }

  public static InvoiceRealLeasehold fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceRealLeasehold entity = new InvoiceRealLeasehold();
    if(map.containsKey("realEstateNo")) {
      Object obj = map.get("realEstateNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRealEstateNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("realEstateAddress")) {
      Object obj = map.get("realEstateAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRealEstateAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("leaseTermStart")) {
      Object obj = map.get("leaseTermStart");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLeaseTermStart((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("leaseTermEnd")) {
      Object obj = map.get("leaseTermEnd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLeaseTermEnd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("crossCitySign")) {
      Object obj = map.get("crossCitySign");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setCrossCitySign((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCrossCitySign(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("areaUnit")) {
      Object obj = map.get("areaUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAreaUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pid")) {
      Object obj = map.get("pid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantCode")) {
      Object obj = map.get("tenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("realEstatePlace")) {
      Object obj = map.get("realEstatePlace");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRealEstatePlace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sourceId")) {
      Object obj = map.get("sourceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sourceItemId")) {
      Object obj = map.get("sourceItemId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceItemId((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("invoiceOneToManyRealLeasehold.id")) {
        Object obj = map.get("invoiceOneToManyRealLeasehold.id");
      if(obj instanceof Long) {
        entity.setInvoiceOneToManyRealLeaseholdId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setInvoiceOneToManyRealLeaseholdId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("realEstateNo")) {
      Object obj = map.get("realEstateNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRealEstateNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("realEstateAddress")) {
      Object obj = map.get("realEstateAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRealEstateAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("leaseTermStart")) {
      Object obj = map.get("leaseTermStart");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLeaseTermStart((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("leaseTermEnd")) {
      Object obj = map.get("leaseTermEnd");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLeaseTermEnd((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("crossCitySign")) {
      Object obj = map.get("crossCitySign");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setCrossCitySign((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCrossCitySign(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("areaUnit")) {
      Object obj = map.get("areaUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAreaUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pid")) {
      Object obj = map.get("pid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tenantCode")) {
      Object obj = map.get("tenantCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("realEstatePlace")) {
      Object obj = map.get("realEstatePlace");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRealEstatePlace((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sourceId")) {
      Object obj = map.get("sourceId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sourceItemId")) {
      Object obj = map.get("sourceItemId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceItemId((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("invoiceOneToManyRealLeasehold.id")) {
        Object obj = map.get("invoiceOneToManyRealLeasehold.id");
        if(obj instanceof Long) {
          this.setInvoiceOneToManyRealLeaseholdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceOneToManyRealLeaseholdId(Long.parseLong((String)obj));
        }
      }
  }
}
