package com.xforceplus.phoenixkylinservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * sales_type
 * </p>
 *
 * @author ultraman
 * @since 2024-08-27
 */
public enum SalesType {

    _01("01", "销售自己使用过的报废产品"),
    _02("02", "销售收购的报废产品");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SalesType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SalesType fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            default:
                return null;
        }
    }
}
