package com.xforceplus.phoenixkylinservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * source
 * </p>
 *
 * @author ultraman
 * @since 2024-08-27
 */
public enum Source {

    _2("2", "协同平台"),
    _3("3", "3.0平台"),
    _4("4", "4.0平台");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Source(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Source fromCode(String code){
        switch(code) {
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
