package com.xforceplus.phoenixkylinservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * vehicle_credential_type
 * </p>
 *
 * @author ultraman
 * @since 2024-08-27
 */
public enum VehicleCredentialType {

    _01("01", "统一社会信用代码/纳税人识别号/身份证号码"),
    _02("02", "其他证件号码");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VehicleCredentialType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VehicleCredentialType fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            default:
                return null;
        }
    }
}
