package com.xforceplus.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.phoenixkylinservice.entity.ConstructionBill;
import com.xforceplus.phoenixkylinservice.service.IConstructionBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-28
 */
@RestController
public class ConstructionBillController {

  @Autowired
  private IConstructionBillService constructionBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param constructionBill ${table.comment}
   * @return
   */
  @GetMapping("/constructionbills" )
  public XfR getConstructionBills(XfPage page, ConstructionBill constructionBill) {
    return XfR.ok(constructionBillServiceImpl.page(page, Wrappers.query(constructionBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/constructionbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(constructionBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param constructionBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/constructionbills")
  public XfR save(@RequestBody ConstructionBill constructionBill) {
     return XfR.ok(constructionBillServiceImpl.save(constructionBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param constructionBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/constructionbills/{id}")
  public XfR putUpdate(@RequestBody ConstructionBill constructionBill,@PathVariable Long id) {
      constructionBill.setId(id);
      return XfR.ok(constructionBillServiceImpl.updateById(constructionBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param constructionBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/constructionbills/{id}")
  public XfR patchUpdate(@RequestBody ConstructionBill constructionBill,@PathVariable Long id) {
      ConstructionBill upconstructionBill = constructionBillServiceImpl.getById(id);
      if(upconstructionBill != null){
        upconstructionBill = ObjectCopyUtils.copyProperties(constructionBill,upconstructionBill,true);
      }
      return XfR.ok(constructionBillServiceImpl.updateById(upconstructionBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/constructionbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(constructionBillServiceImpl.removeById(id));
  }

  @PostMapping("/constructionbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "construction_bill");
     params.put("request", condition);

     return XfR.ok(constructionBillServiceImpl.querys(params));
  }

}
