package com.xforceplus.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.phoenixkylinservice.entity.ConstructionBillItem;
import com.xforceplus.phoenixkylinservice.service.IConstructionBillItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-28
 */
@RestController
public class ConstructionBillItemController {

  @Autowired
  private IConstructionBillItemService constructionBillItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param constructionBillItem ${table.comment}
   * @return
   */
  @GetMapping("/constructionbillitems" )
  public XfR getConstructionBillItems(XfPage page, ConstructionBillItem constructionBillItem) {
    return XfR.ok(constructionBillItemServiceImpl.page(page, Wrappers.query(constructionBillItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/constructionbillitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(constructionBillItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param constructionBillItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/constructionbillitems")
  public XfR save(@RequestBody ConstructionBillItem constructionBillItem) {
     return XfR.ok(constructionBillItemServiceImpl.save(constructionBillItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param constructionBillItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/constructionbillitems/{id}")
  public XfR putUpdate(@RequestBody ConstructionBillItem constructionBillItem,@PathVariable Long id) {
      constructionBillItem.setId(id);
      return XfR.ok(constructionBillItemServiceImpl.updateById(constructionBillItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param constructionBillItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/constructionbillitems/{id}")
  public XfR patchUpdate(@RequestBody ConstructionBillItem constructionBillItem,@PathVariable Long id) {
      ConstructionBillItem upconstructionBillItem = constructionBillItemServiceImpl.getById(id);
      if(upconstructionBillItem != null){
        upconstructionBillItem = ObjectCopyUtils.copyProperties(constructionBillItem,upconstructionBillItem,true);
      }
      return XfR.ok(constructionBillItemServiceImpl.updateById(upconstructionBillItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/constructionbillitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(constructionBillItemServiceImpl.removeById(id));
  }

  @PostMapping("/constructionbillitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "construction_bill_item");
     params.put("request", condition);

     return XfR.ok(constructionBillItemServiceImpl.querys(params));
  }

}
