package com.xforceplus.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.phoenixkylinservice.entity.FreightSalesageBillItem;
import com.xforceplus.phoenixkylinservice.service.IFreightSalesageBillItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-28
 */
@RestController
public class FreightSalesageBillItemController {

  @Autowired
  private IFreightSalesageBillItemService freightSalesageBillItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param freightSalesageBillItem ${table.comment}
   * @return
   */
  @GetMapping("/freightsalesagebillitems" )
  public XfR getFreightSalesageBillItems(XfPage page, FreightSalesageBillItem freightSalesageBillItem) {
    return XfR.ok(freightSalesageBillItemServiceImpl.page(page, Wrappers.query(freightSalesageBillItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/freightsalesagebillitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(freightSalesageBillItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param freightSalesageBillItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/freightsalesagebillitems")
  public XfR save(@RequestBody FreightSalesageBillItem freightSalesageBillItem) {
     return XfR.ok(freightSalesageBillItemServiceImpl.save(freightSalesageBillItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param freightSalesageBillItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/freightsalesagebillitems/{id}")
  public XfR putUpdate(@RequestBody FreightSalesageBillItem freightSalesageBillItem,@PathVariable Long id) {
      freightSalesageBillItem.setId(id);
      return XfR.ok(freightSalesageBillItemServiceImpl.updateById(freightSalesageBillItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param freightSalesageBillItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/freightsalesagebillitems/{id}")
  public XfR patchUpdate(@RequestBody FreightSalesageBillItem freightSalesageBillItem,@PathVariable Long id) {
      FreightSalesageBillItem upfreightSalesageBillItem = freightSalesageBillItemServiceImpl.getById(id);
      if(upfreightSalesageBillItem != null){
        upfreightSalesageBillItem = ObjectCopyUtils.copyProperties(freightSalesageBillItem,upfreightSalesageBillItem,true);
      }
      return XfR.ok(freightSalesageBillItemServiceImpl.updateById(upfreightSalesageBillItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/freightsalesagebillitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(freightSalesageBillItemServiceImpl.removeById(id));
  }

  @PostMapping("/freightsalesagebillitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "freight_salesage_bill_item");
     params.put("request", condition);

     return XfR.ok(freightSalesageBillItemServiceImpl.querys(params));
  }

}
