package com.xforceplus.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.phoenixkylinservice.entity.FreightageItemBill;
import com.xforceplus.phoenixkylinservice.service.IFreightageItemBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-28
 */
@RestController
public class FreightageItemBillController {

  @Autowired
  private IFreightageItemBillService freightageItemBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param freightageItemBill ${table.comment}
   * @return
   */
  @GetMapping("/freightageitembills" )
  public XfR getFreightageItemBills(XfPage page, FreightageItemBill freightageItemBill) {
    return XfR.ok(freightageItemBillServiceImpl.page(page, Wrappers.query(freightageItemBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/freightageitembills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(freightageItemBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param freightageItemBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/freightageitembills")
  public XfR save(@RequestBody FreightageItemBill freightageItemBill) {
     return XfR.ok(freightageItemBillServiceImpl.save(freightageItemBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param freightageItemBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/freightageitembills/{id}")
  public XfR putUpdate(@RequestBody FreightageItemBill freightageItemBill,@PathVariable Long id) {
      freightageItemBill.setId(id);
      return XfR.ok(freightageItemBillServiceImpl.updateById(freightageItemBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param freightageItemBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/freightageitembills/{id}")
  public XfR patchUpdate(@RequestBody FreightageItemBill freightageItemBill,@PathVariable Long id) {
      FreightageItemBill upfreightageItemBill = freightageItemBillServiceImpl.getById(id);
      if(upfreightageItemBill != null){
        upfreightageItemBill = ObjectCopyUtils.copyProperties(freightageItemBill,upfreightageItemBill,true);
      }
      return XfR.ok(freightageItemBillServiceImpl.updateById(upfreightageItemBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/freightageitembills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(freightageItemBillServiceImpl.removeById(id));
  }

  @PostMapping("/freightageitembills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "freightage_item_bill");
     params.put("request", condition);

     return XfR.ok(freightageItemBillServiceImpl.querys(params));
  }

}
