package com.xforceplus.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.phoenixkylinservice.entity.InvSellerPreInvoice;
import com.xforceplus.phoenixkylinservice.service.IInvSellerPreInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 4.0前端控制器
 *
 * @author ultraman
 * @date 2022-12-28
 */
@RestController
public class InvSellerPreInvoiceController {

  @Autowired
  private IInvSellerPreInvoiceService invSellerPreInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invSellerPreInvoice 4.0
   * @return
   */
  @GetMapping("/invsellerpreinvoices" )
  public XfR getInvSellerPreInvoices(XfPage page, InvSellerPreInvoice invSellerPreInvoice) {
    return XfR.ok(invSellerPreInvoiceServiceImpl.page(page, Wrappers.query(invSellerPreInvoice)));
  }

  /**
   * 通过id查询4.0
   * @param  id
   * @return XfR
   */
  @GetMapping("/invsellerpreinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invSellerPreInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增4.0
   * @param invSellerPreInvoice 4.0
   * @return XfR
   */
  @PostMapping("/invsellerpreinvoices")
  public XfR save(@RequestBody InvSellerPreInvoice invSellerPreInvoice) {
     return XfR.ok(invSellerPreInvoiceServiceImpl.save(invSellerPreInvoice));
  }

  /**
   * 修改-传入修改后的全部数据4.0
   * @param invSellerPreInvoice 4.0
   * @return XfR
   */
  @PutMapping("/invsellerpreinvoices/{id}")
  public XfR putUpdate(@RequestBody InvSellerPreInvoice invSellerPreInvoice,@PathVariable Long id) {
      invSellerPreInvoice.setId(id);
      return XfR.ok(invSellerPreInvoiceServiceImpl.updateById(invSellerPreInvoice));
  }

  /**
   * 修改-传入修改的数据4.0
   * @param invSellerPreInvoice 4.0
   * @return XfR
   */
  @PatchMapping("/invsellerpreinvoices/{id}")
  public XfR patchUpdate(@RequestBody InvSellerPreInvoice invSellerPreInvoice,@PathVariable Long id) {
      InvSellerPreInvoice upinvSellerPreInvoice = invSellerPreInvoiceServiceImpl.getById(id);
      if(upinvSellerPreInvoice != null){
        upinvSellerPreInvoice = ObjectCopyUtils.copyProperties(invSellerPreInvoice,upinvSellerPreInvoice,true);
      }
      return XfR.ok(invSellerPreInvoiceServiceImpl.updateById(upinvSellerPreInvoice));
  }

  /**
   * 通过id删除4.0
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invsellerpreinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invSellerPreInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/invsellerpreinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inv_seller_pre_invoice");
     params.put("request", condition);

     return XfR.ok(invSellerPreInvoiceServiceImpl.querys(params));
  }

}
