package com.xforceplus.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.phoenixkylinservice.entity.OrdSalesbillItem;
import com.xforceplus.phoenixkylinservice.service.IOrdSalesbillItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 4.0前端控制器
 *
 * @author ultraman
 * @date 2022-12-28
 */
@RestController
public class OrdSalesbillItemController {

  @Autowired
  private IOrdSalesbillItemService ordSalesbillItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordSalesbillItem 4.0
   * @return
   */
  @GetMapping("/ordsalesbillitems" )
  public XfR getOrdSalesbillItems(XfPage page, OrdSalesbillItem ordSalesbillItem) {
    return XfR.ok(ordSalesbillItemServiceImpl.page(page, Wrappers.query(ordSalesbillItem)));
  }

  /**
   * 通过id查询4.0
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordsalesbillitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillItemServiceImpl.getById(id));
  }

  /**
   * 新增4.0
   * @param ordSalesbillItem 4.0
   * @return XfR
   */
  @PostMapping("/ordsalesbillitems")
  public XfR save(@RequestBody OrdSalesbillItem ordSalesbillItem) {
     return XfR.ok(ordSalesbillItemServiceImpl.save(ordSalesbillItem));
  }

  /**
   * 修改-传入修改后的全部数据4.0
   * @param ordSalesbillItem 4.0
   * @return XfR
   */
  @PutMapping("/ordsalesbillitems/{id}")
  public XfR putUpdate(@RequestBody OrdSalesbillItem ordSalesbillItem,@PathVariable Long id) {
      ordSalesbillItem.setId(id);
      return XfR.ok(ordSalesbillItemServiceImpl.updateById(ordSalesbillItem));
  }

  /**
   * 修改-传入修改的数据4.0
   * @param ordSalesbillItem 4.0
   * @return XfR
   */
  @PatchMapping("/ordsalesbillitems/{id}")
  public XfR patchUpdate(@RequestBody OrdSalesbillItem ordSalesbillItem,@PathVariable Long id) {
      OrdSalesbillItem upordSalesbillItem = ordSalesbillItemServiceImpl.getById(id);
      if(upordSalesbillItem != null){
        upordSalesbillItem = ObjectCopyUtils.copyProperties(ordSalesbillItem,upordSalesbillItem,true);
      }
      return XfR.ok(ordSalesbillItemServiceImpl.updateById(upordSalesbillItem));
  }

  /**
   * 通过id删除4.0
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordsalesbillitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordSalesbillItemServiceImpl.removeById(id));
  }

  @PostMapping("/ordsalesbillitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ord_salesbill_item");
     params.put("request", condition);

     return XfR.ok(ordSalesbillItemServiceImpl.querys(params));
  }

}
