package com.xforceplus.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.phoenixkylinservice.entity.RealEstateSalesInvoice;
import com.xforceplus.phoenixkylinservice.service.IRealEstateSalesInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-28
 */
@RestController
public class RealEstateSalesInvoiceController {

  @Autowired
  private IRealEstateSalesInvoiceService realEstateSalesInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param realEstateSalesInvoice ${table.comment}
   * @return
   */
  @GetMapping("/realestatesalesinvoices" )
  public XfR getRealEstateSalesInvoices(XfPage page, RealEstateSalesInvoice realEstateSalesInvoice) {
    return XfR.ok(realEstateSalesInvoiceServiceImpl.page(page, Wrappers.query(realEstateSalesInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/realestatesalesinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(realEstateSalesInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param realEstateSalesInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/realestatesalesinvoices")
  public XfR save(@RequestBody RealEstateSalesInvoice realEstateSalesInvoice) {
     return XfR.ok(realEstateSalesInvoiceServiceImpl.save(realEstateSalesInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param realEstateSalesInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/realestatesalesinvoices/{id}")
  public XfR putUpdate(@RequestBody RealEstateSalesInvoice realEstateSalesInvoice,@PathVariable Long id) {
      realEstateSalesInvoice.setId(id);
      return XfR.ok(realEstateSalesInvoiceServiceImpl.updateById(realEstateSalesInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param realEstateSalesInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/realestatesalesinvoices/{id}")
  public XfR patchUpdate(@RequestBody RealEstateSalesInvoice realEstateSalesInvoice,@PathVariable Long id) {
      RealEstateSalesInvoice uprealEstateSalesInvoice = realEstateSalesInvoiceServiceImpl.getById(id);
      if(uprealEstateSalesInvoice != null){
        uprealEstateSalesInvoice = ObjectCopyUtils.copyProperties(realEstateSalesInvoice,uprealEstateSalesInvoice,true);
      }
      return XfR.ok(realEstateSalesInvoiceServiceImpl.updateById(uprealEstateSalesInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/realestatesalesinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(realEstateSalesInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/realestatesalesinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "real_estate_sales_invoice");
     params.put("request", condition);

     return XfR.ok(realEstateSalesInvoiceServiceImpl.querys(params));
  }

}
