package com.xforceplus.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.phoenixkylinservice.entity.RealEstateSalesInvoiceItem;
import com.xforceplus.phoenixkylinservice.service.IRealEstateSalesInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-28
 */
@RestController
public class RealEstateSalesInvoiceItemController {

  @Autowired
  private IRealEstateSalesInvoiceItemService realEstateSalesInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param realEstateSalesInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/realestatesalesinvoiceitems" )
  public XfR getRealEstateSalesInvoiceItems(XfPage page, RealEstateSalesInvoiceItem realEstateSalesInvoiceItem) {
    return XfR.ok(realEstateSalesInvoiceItemServiceImpl.page(page, Wrappers.query(realEstateSalesInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/realestatesalesinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(realEstateSalesInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param realEstateSalesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/realestatesalesinvoiceitems")
  public XfR save(@RequestBody RealEstateSalesInvoiceItem realEstateSalesInvoiceItem) {
     return XfR.ok(realEstateSalesInvoiceItemServiceImpl.save(realEstateSalesInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param realEstateSalesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/realestatesalesinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody RealEstateSalesInvoiceItem realEstateSalesInvoiceItem,@PathVariable Long id) {
      realEstateSalesInvoiceItem.setId(id);
      return XfR.ok(realEstateSalesInvoiceItemServiceImpl.updateById(realEstateSalesInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param realEstateSalesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/realestatesalesinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody RealEstateSalesInvoiceItem realEstateSalesInvoiceItem,@PathVariable Long id) {
      RealEstateSalesInvoiceItem uprealEstateSalesInvoiceItem = realEstateSalesInvoiceItemServiceImpl.getById(id);
      if(uprealEstateSalesInvoiceItem != null){
        uprealEstateSalesInvoiceItem = ObjectCopyUtils.copyProperties(realEstateSalesInvoiceItem,uprealEstateSalesInvoiceItem,true);
      }
      return XfR.ok(realEstateSalesInvoiceItemServiceImpl.updateById(uprealEstateSalesInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/realestatesalesinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(realEstateSalesInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/realestatesalesinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "real_estate_sales_invoice_item");
     params.put("request", condition);

     return XfR.ok(realEstateSalesInvoiceItemServiceImpl.querys(params));
  }

}
