package com.xforceplus.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.phoenixkylinservice.entity.RealLeaseholdBill;
import com.xforceplus.phoenixkylinservice.service.IRealLeaseholdBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-28
 */
@RestController
public class RealLeaseholdBillController {

  @Autowired
  private IRealLeaseholdBillService realLeaseholdBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param realLeaseholdBill ${table.comment}
   * @return
   */
  @GetMapping("/realleaseholdbills" )
  public XfR getRealLeaseholdBills(XfPage page, RealLeaseholdBill realLeaseholdBill) {
    return XfR.ok(realLeaseholdBillServiceImpl.page(page, Wrappers.query(realLeaseholdBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/realleaseholdbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(realLeaseholdBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param realLeaseholdBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/realleaseholdbills")
  public XfR save(@RequestBody RealLeaseholdBill realLeaseholdBill) {
     return XfR.ok(realLeaseholdBillServiceImpl.save(realLeaseholdBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param realLeaseholdBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/realleaseholdbills/{id}")
  public XfR putUpdate(@RequestBody RealLeaseholdBill realLeaseholdBill,@PathVariable Long id) {
      realLeaseholdBill.setId(id);
      return XfR.ok(realLeaseholdBillServiceImpl.updateById(realLeaseholdBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param realLeaseholdBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/realleaseholdbills/{id}")
  public XfR patchUpdate(@RequestBody RealLeaseholdBill realLeaseholdBill,@PathVariable Long id) {
      RealLeaseholdBill uprealLeaseholdBill = realLeaseholdBillServiceImpl.getById(id);
      if(uprealLeaseholdBill != null){
        uprealLeaseholdBill = ObjectCopyUtils.copyProperties(realLeaseholdBill,uprealLeaseholdBill,true);
      }
      return XfR.ok(realLeaseholdBillServiceImpl.updateById(uprealLeaseholdBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/realleaseholdbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(realLeaseholdBillServiceImpl.removeById(id));
  }

  @PostMapping("/realleaseholdbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "real_leasehold_bill");
     params.put("request", condition);

     return XfR.ok(realLeaseholdBillServiceImpl.querys(params));
  }

}
