package com.xforceplus.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.phoenixkylinservice.entity.RealLeaseholdPreInvoice;
import com.xforceplus.phoenixkylinservice.service.IRealLeaseholdPreInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-28
 */
@RestController
public class RealLeaseholdPreInvoiceController {

  @Autowired
  private IRealLeaseholdPreInvoiceService realLeaseholdPreInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param realLeaseholdPreInvoice ${table.comment}
   * @return
   */
  @GetMapping("/realleaseholdpreinvoices" )
  public XfR getRealLeaseholdPreInvoices(XfPage page, RealLeaseholdPreInvoice realLeaseholdPreInvoice) {
    return XfR.ok(realLeaseholdPreInvoiceServiceImpl.page(page, Wrappers.query(realLeaseholdPreInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/realleaseholdpreinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(realLeaseholdPreInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param realLeaseholdPreInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/realleaseholdpreinvoices")
  public XfR save(@RequestBody RealLeaseholdPreInvoice realLeaseholdPreInvoice) {
     return XfR.ok(realLeaseholdPreInvoiceServiceImpl.save(realLeaseholdPreInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param realLeaseholdPreInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/realleaseholdpreinvoices/{id}")
  public XfR putUpdate(@RequestBody RealLeaseholdPreInvoice realLeaseholdPreInvoice,@PathVariable Long id) {
      realLeaseholdPreInvoice.setId(id);
      return XfR.ok(realLeaseholdPreInvoiceServiceImpl.updateById(realLeaseholdPreInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param realLeaseholdPreInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/realleaseholdpreinvoices/{id}")
  public XfR patchUpdate(@RequestBody RealLeaseholdPreInvoice realLeaseholdPreInvoice,@PathVariable Long id) {
      RealLeaseholdPreInvoice uprealLeaseholdPreInvoice = realLeaseholdPreInvoiceServiceImpl.getById(id);
      if(uprealLeaseholdPreInvoice != null){
        uprealLeaseholdPreInvoice = ObjectCopyUtils.copyProperties(realLeaseholdPreInvoice,uprealLeaseholdPreInvoice,true);
      }
      return XfR.ok(realLeaseholdPreInvoiceServiceImpl.updateById(uprealLeaseholdPreInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/realleaseholdpreinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(realLeaseholdPreInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/realleaseholdpreinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "real_leasehold_pre_invoice");
     params.put("request", condition);

     return XfR.ok(realLeaseholdPreInvoiceServiceImpl.querys(params));
  }

}
