package com.xforceplus.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.phoenixkylinservice.entity.RealLeaseholdPreInvoiceItem;
import com.xforceplus.phoenixkylinservice.service.IRealLeaseholdPreInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-28
 */
@RestController
public class RealLeaseholdPreInvoiceItemController {

  @Autowired
  private IRealLeaseholdPreInvoiceItemService realLeaseholdPreInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param realLeaseholdPreInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/realleaseholdpreinvoiceitems" )
  public XfR getRealLeaseholdPreInvoiceItems(XfPage page, RealLeaseholdPreInvoiceItem realLeaseholdPreInvoiceItem) {
    return XfR.ok(realLeaseholdPreInvoiceItemServiceImpl.page(page, Wrappers.query(realLeaseholdPreInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/realleaseholdpreinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(realLeaseholdPreInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param realLeaseholdPreInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/realleaseholdpreinvoiceitems")
  public XfR save(@RequestBody RealLeaseholdPreInvoiceItem realLeaseholdPreInvoiceItem) {
     return XfR.ok(realLeaseholdPreInvoiceItemServiceImpl.save(realLeaseholdPreInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param realLeaseholdPreInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/realleaseholdpreinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody RealLeaseholdPreInvoiceItem realLeaseholdPreInvoiceItem,@PathVariable Long id) {
      realLeaseholdPreInvoiceItem.setId(id);
      return XfR.ok(realLeaseholdPreInvoiceItemServiceImpl.updateById(realLeaseholdPreInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param realLeaseholdPreInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/realleaseholdpreinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody RealLeaseholdPreInvoiceItem realLeaseholdPreInvoiceItem,@PathVariable Long id) {
      RealLeaseholdPreInvoiceItem uprealLeaseholdPreInvoiceItem = realLeaseholdPreInvoiceItemServiceImpl.getById(id);
      if(uprealLeaseholdPreInvoiceItem != null){
        uprealLeaseholdPreInvoiceItem = ObjectCopyUtils.copyProperties(realLeaseholdPreInvoiceItem,uprealLeaseholdPreInvoiceItem,true);
      }
      return XfR.ok(realLeaseholdPreInvoiceItemServiceImpl.updateById(uprealLeaseholdPreInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/realleaseholdpreinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(realLeaseholdPreInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/realleaseholdpreinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "real_leasehold_pre_invoice_item");
     params.put("request", condition);

     return XfR.ok(realLeaseholdPreInvoiceItemServiceImpl.querys(params));
  }

}
