package com.xforceplus.policymanagement.controller;


/**
 * 人员组织关系系统对象feign客户端
 *
 * @author ultraman
 * @date 2024-10-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.SystemRelOrgUser;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface SystemRelOrgUserFeignApi {

  /**
   * 通过id查询人员组织关系系统对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemRelOrgUser/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增人员组织关系系统对象
   * @param systemRelOrgUser 人员组织关系系统对象
   * @return R
   */
  @PostMapping("/systemRelOrgUser/add")
  public R save(@RequestBody SystemRelOrgUser systemRelOrgUser);

  /**
   * 修改人员组织关系系统对象
   * @param systemRelOrgUser 人员组织关系系统对象
   * @return R
   */
  @PostMapping("/systemRelOrgUser/update")
  public R updateById(@RequestBody SystemRelOrgUser systemRelOrgUser);

  /**
   * 通过id删除人员组织关系系统对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemRelOrgUser/del/{id}" )
  public R removeById(@PathVariable Long id);

}