package com.xforceplus.policymanagement.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-10-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.PolicyManagementDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface PolicyManagementDetailFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/policyManagementDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param policyManagementDetail ${table.comment}
   * @return R
   */
  @PostMapping("/policyManagementDetail/add")
  public R save(@RequestBody PolicyManagementDetail policyManagementDetail);

  /**
   * 修改${table.comment}
   * @param policyManagementDetail ${table.comment}
   * @return R
   */
  @PostMapping("/policyManagementDetail/update")
  public R updateById(@RequestBody PolicyManagementDetail policyManagementDetail);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/policyManagementDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}