package com.xforceplus.policymanagement.controller;


/**
 * 系统站内信对象feign客户端
 *
 * @author ultraman
 * @date 2024-10-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.SystemInbox;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface SystemInboxFeignApi {

  /**
   * 通过id查询系统站内信对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemInbox/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统站内信对象
   * @param systemInbox 系统站内信对象
   * @return R
   */
  @PostMapping("/systemInbox/add")
  public R save(@RequestBody SystemInbox systemInbox);

  /**
   * 修改系统站内信对象
   * @param systemInbox 系统站内信对象
   * @return R
   */
  @PostMapping("/systemInbox/update")
  public R updateById(@RequestBody SystemInbox systemInbox);

  /**
   * 通过id删除系统站内信对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemInbox/del/{id}" )
  public R removeById(@PathVariable Long id);

}