package com.xforceplus.policymanagement.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-11-15
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.KsAfterSale;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface KsAfterSaleFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/ksAfterSale/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param ksAfterSale ${table.comment}
   * @return R
   */
  @PostMapping("/ksAfterSale/add")
  public R save(@RequestBody KsAfterSale ksAfterSale);

  /**
   * 修改${table.comment}
   * @param ksAfterSale ${table.comment}
   * @return R
   */
  @PostMapping("/ksAfterSale/update")
  public R updateById(@RequestBody KsAfterSale ksAfterSale);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/ksAfterSale/del/{id}" )
  public R removeById(@PathVariable Long id);

}